/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.go;

import com.liferay.gradle.plugins.go.GoExtension;
import com.liferay.gradle.plugins.go.internal.util.FileUtil;
import com.liferay.gradle.plugins.go.internal.util.GradleUtil;
import com.liferay.gradle.plugins.go.internal.util.StringUtil;
import com.liferay.gradle.plugins.go.tasks.DownloadGoTask;
import com.liferay.gradle.plugins.go.tasks.ExecuteGoTask;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;

public class GoPlugin
implements Plugin<Project> {
    public static final String DOWNLOAD_GO_TASK_NAME = "downloadGo";
    public static final String EXTENSION_NAME = "go";

    public void apply(Project project) {
        GoExtension goExtension = (GoExtension)GradleUtil.addExtension((ExtensionAware)project, (String)EXTENSION_NAME, GoExtension.class);
        DownloadGoTask downloadGoTask = this.addTaskDownloadGo(project);
        this._configureTasksExecuteGo(project, GradleUtil.isRunningInsideDaemon());
        this._addTasksExecuteGo(downloadGoTask, goExtension);
    }

    protected DownloadGoTask addTaskDownloadGo(Project project) {
        return (DownloadGoTask)GradleUtil.addTask((Project)project, (String)DOWNLOAD_GO_TASK_NAME, DownloadGoTask.class);
    }

    private ExecuteGoTask _addTaskExecuteGo(String command, String description, File file, DownloadGoTask downloadGoTask) {
        ExecuteGoTask executeGoTask = (ExecuteGoTask)GradleUtil.addTask((Project)downloadGoTask.getProject(), (String)this._getTaskName(command, file), ExecuteGoTask.class);
        executeGoTask.dependsOn(new Object[]{downloadGoTask});
        executeGoTask.setArgs(command, file.getAbsolutePath());
        executeGoTask.setDescription(description);
        executeGoTask.setGroup("build");
        return executeGoTask;
    }

    private void _addTasksExecuteGo(DownloadGoTask downloadGoTask, GoExtension goExtension) {
        File[] files = FileUtil.getFiles(goExtension.getWorkingDir(), EXTENSION_NAME);
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            StringBuilder sb = new StringBuilder();
            sb.append("Compile packages and dependencies for the \"");
            sb.append(FileUtil.getSimpleName(file));
            sb.append("\" Go program.");
            this._addTaskExecuteGo("build", sb.toString(), file, downloadGoTask);
            sb.setLength(0);
            sb.append("Removes object files for the \"");
            sb.append(FileUtil.getSimpleName(file));
            sb.append("\" Go program.");
            this._addTaskExecuteGo("clean", sb.toString(), file, downloadGoTask);
            sb.setLength(0);
            sb.append("Compile and run the \"");
            sb.append(FileUtil.getSimpleName(file));
            sb.append("\" Go program.");
            this._addTaskExecuteGo("run", sb.toString(), file, downloadGoTask);
            sb.setLength(0);
            sb.append("Test packages for the \"");
            sb.append(FileUtil.getSimpleName(file));
            sb.append("\" Go program.");
            this._addTaskExecuteGo("test", sb.toString(), file, downloadGoTask);
        }
    }

    private void _configureTaskExecuteGo(ExecuteGoTask executeGoTask, boolean useGradleExec) {
        executeGoTask.setUseGradleExec(useGradleExec);
    }

    private void _configureTasksExecuteGo(Project project, final boolean useGradleExec) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteGoTask.class, (Action)new Action<ExecuteGoTask>(){

            public void execute(ExecuteGoTask executeGoTask) {
                GoPlugin.this._configureTaskExecuteGo(executeGoTask, useGradleExec);
            }
        });
    }

    private String _getTaskName(String command, File file) {
        String s = StringUtil.camelCase(FileUtil.getSimpleName(file), true);
        return EXTENSION_NAME + StringUtil.camelCase(command, true) + s;
    }
}

