/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.go;

import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Project;

public class GoExtension {
    private Object _goDir;
    private Object _goUrl;
    private Object _goVersion = "1.11.4";
    private final Project _project;
    private Object _workingDir;

    public GoExtension(Project project) {
        this._goDir = new File(project.getBuildDir(), "go");
        this._goUrl = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String goVersion = GoExtension.this.getGoVersion();
                if (Validator.isNull((String)goVersion)) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("https://dl.google.com/go/go");
                sb.append(goVersion);
                sb.append('.');
                String bitmode = OSDetector.getBitmode();
                if (OSDetector.isApple()) {
                    sb.append("darwin-amd64.tar.gz");
                } else if (OSDetector.isWindows()) {
                    if (bitmode.equals("64")) {
                        sb.append("windows-amd64.zip");
                    } else {
                        sb.append("windows-386.zip");
                    }
                } else if (bitmode.equals("64")) {
                    sb.append("linux-amd64.tar.gz");
                } else {
                    sb.append("linux-386.tar.gz");
                }
                return sb.toString();
            }
        };
        this._workingDir = project.getProjectDir();
        this._project = project;
    }

    public File getGoDir() {
        return GradleUtil.toFile((Project)this._project, (Object)this._goDir);
    }

    public String getGoUrl() {
        return GradleUtil.toString((Object)this._goUrl);
    }

    public String getGoVersion() {
        return GradleUtil.toString((Object)this._goVersion);
    }

    public File getWorkingDir() {
        return GradleUtil.toFile((Project)this._project, (Object)this._workingDir);
    }

    public void setGoDir(Object goDir) {
        this._goDir = goDir;
    }

    public void setGoUrl(Object goUrl) {
        this._goUrl = goUrl;
    }

    public void setGoVersion(Object goVersion) {
        this._goVersion = goVersion;
    }

    public void setWorkingDir(Object workingDir) {
        this._workingDir = workingDir;
    }
}

