/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.dependency.checker.internal;

import com.liferay.gradle.plugins.dependency.checker.DependencyCheckerException;
import com.liferay.gradle.plugins.dependency.checker.internal.BaseDependencyCheckerImpl;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonSlurper;
import groovy.time.Duration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.jodah.expiringmap.ExpiringMap;
import org.gradle.api.logging.Logger;

public class MaxAgeDependencyCheckerImpl
extends BaseDependencyCheckerImpl {
    private static final String _ENCODED_DOUBLE_QUOTE = "%22";
    private static final ExpiringMap<URL, VersionInfo> _versionInfos = ExpiringMap.create();
    private final Logger _logger;
    private Duration _maxAge;

    public MaxAgeDependencyCheckerImpl(Logger logger) {
        this._logger = logger;
    }

    @Override
    public void check(String group, String name, String version) throws Exception {
        VersionInfo latestVersionInfo = this._getVersionInfo(group, name, null);
        if (latestVersionInfo.equals(VersionInfo.MISSING)) {
            if (this._logger.isWarnEnabled()) {
                this._logger.warn("Unable to get information about the latest version of '{}:{}'", (Object)group, (Object)name);
            }
            return;
        }
        Date latestDate = new Date(latestVersionInfo.timestamp);
        if (latestVersionInfo.version.equals(version)) {
            if (this._logger.isInfoEnabled()) {
                this._logger.info("Dependency '{}:{}:{}', published {}, is the latest one available", new Object[]{group, name, version, latestDate});
            }
            return;
        }
        VersionInfo currentVersionInfo = this._getVersionInfo(group, name, version);
        if (currentVersionInfo.equals(VersionInfo.MISSING)) {
            if (this._logger.isInfoEnabled()) {
                this._logger.info("Unable to get information about '{}:{}:{}'", new Object[]{group, name, version});
            }
            return;
        }
        Date currentDate = new Date(currentVersionInfo.timestamp);
        if (latestVersionInfo.timestamp <= currentVersionInfo.timestamp + this._maxAge.toMilliseconds()) {
            if (this._logger.isWarnEnabled()) {
                this._logger.warn("Dependency '{}:{}:{}', published {}, is older than the latest one available ('{}:{}:{}', published {}), but not yet expired", new Object[]{group, name, version, currentDate, group, name, latestVersionInfo.version, latestDate});
            }
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Dependency '");
        sb.append(group);
        sb.append(':');
        sb.append(name);
        sb.append(':');
        sb.append(version);
        sb.append("', published ");
        sb.append(currentDate);
        sb.append(", is more than ");
        sb.append(this._maxAge);
        sb.append(" older than the latest one available ('");
        sb.append(group);
        sb.append(':');
        sb.append(name);
        sb.append(':');
        sb.append(latestVersionInfo.version);
        sb.append("', published ");
        sb.append(latestDate);
        sb.append("), and it is expired");
        if (this.isThrowError()) {
            throw new DependencyCheckerException(sb.toString());
        }
        if (this._logger.isWarnEnabled()) {
            this._logger.warn(sb.toString());
        }
    }

    public Duration getMaxAge() {
        return this._maxAge;
    }

    public void setMaxAge(Duration maxAge) {
        this._maxAge = maxAge;
    }

    private VersionInfo _getVersionInfo(String group, String name, String version) throws MalformedURLException {
        URL url = this._getVersionInfoURL(group, name, version);
        VersionInfo versionInfo = (VersionInfo)_versionInfos.get((Object)url);
        if (versionInfo != null) {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Cache hit for {}: {}", (Object)url, (Object)versionInfo);
            }
            return versionInfo;
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map map = (Map)jsonSlurper.parse(url);
        Map responseMap = (Map)map.get("response");
        List docsList = (List)responseMap.get("docs");
        if (docsList.isEmpty()) {
            versionInfo = VersionInfo.MISSING;
        } else {
            Map docMap = (Map)docsList.get(0);
            long timestamp = (Long)docMap.get("timestamp");
            if (Validator.isNull((String)version)) {
                version = (String)docMap.get("latestVersion");
            }
            versionInfo = new VersionInfo(timestamp, version);
        }
        _versionInfos.put((Object)url, (Object)versionInfo);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Cache miss for {}: {}", (Object)url, (Object)versionInfo);
        }
        return versionInfo;
    }

    private URL _getVersionInfoURL(String group, String name, String version) throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append("https://search.maven.org/solrsearch/select?q=g:");
        sb.append(_ENCODED_DOUBLE_QUOTE);
        sb.append(group);
        sb.append(_ENCODED_DOUBLE_QUOTE);
        sb.append("+AND+a:");
        sb.append(_ENCODED_DOUBLE_QUOTE);
        sb.append(name);
        sb.append(_ENCODED_DOUBLE_QUOTE);
        if (Validator.isNotNull((String)version)) {
            sb.append("+AND+v:");
            sb.append(_ENCODED_DOUBLE_QUOTE);
            sb.append(version);
            sb.append(_ENCODED_DOUBLE_QUOTE);
        }
        sb.append("&wt=json");
        return new URL(sb.toString());
    }

    private static class VersionInfo {
        public static final VersionInfo MISSING = new VersionInfo(0L, "");
        public final long timestamp;
        public final String version;

        public VersionInfo(long timestamp, String version) {
            this.timestamp = timestamp;
            this.version = version;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof VersionInfo)) {
                return false;
            }
            VersionInfo versionInfo = (VersionInfo)obj;
            return this.timestamp == versionInfo.timestamp && this.version.equals(versionInfo.version);
        }

        public int hashCode() {
            String s = this.toString();
            return s.hashCode();
        }

        public String toString() {
            if (this.equals(MISSING)) {
                return "MISSING";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("timestamp=");
            sb.append(this.timestamp);
            sb.append(", version=");
            sb.append(this.version);
            return sb.toString();
        }
    }
}

