/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import aQute.bnd.version.Version;
import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.LiferayOSGiDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.task.ReplaceRegexTask;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import groovy.lang.Closure;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GUtil;
import org.gradle.util.VersionNumber;

public class LiferayOSGiPortalCompatDefaultsPlugin
extends BaseDefaultsPlugin<LiferayOSGiDefaultsPlugin> {
    public static final String BYTECODE_TRANSFORMER_CONFIGURATION_NAME = "bytecodeTransformer";
    public static final String IMPORT_FILES_TASK_NAME = "importFiles";
    public static final String TRANSFORM_IMPORTED_FILES_TASK_NAME = "transformImportedFiles";

    protected void applyPluginDefaults(Project project, LiferayOSGiDefaultsPlugin liferayOSGiDefaultsPlugin) {
        File portalRootDir = GradleUtil.getRootDir((Project)project.getRootProject(), (String)"portal-impl");
        Configuration bytecodeTransformerConfiguration = this._addConfigurationBytecodeTransformer(project);
        Copy importFilesTask = this._addTaskImportFiles(project);
        JavaExec transformImportedFilesTask = this._addTaskTransformImportedFiles(importFilesTask, bytecodeTransformerConfiguration);
        this._configureLiferay(project, portalRootDir);
        this._configureTaskClasses(transformImportedFilesTask);
        this._configureTaskImportFiles(importFilesTask);
        this._configureTaskUpdateFileVersions(project, portalRootDir);
    }

    protected Class<LiferayOSGiDefaultsPlugin> getPluginClass() {
        return LiferayOSGiDefaultsPlugin.class;
    }

    private Configuration _addConfigurationBytecodeTransformer(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)BYTECODE_TRANSFORMER_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                LiferayOSGiPortalCompatDefaultsPlugin.this._addDependenciesBytecodeTransformer(project);
            }
        });
        configuration.setDescription("Configures Liferay Portal Tools Portal Compat Bytecode Transformer.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesBytecodeTransformer(Project project) {
        GradleUtil.addDependency((Project)project, (String)BYTECODE_TRANSFORMER_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.portal.tools.portal.compat.bytecode.transformer", (String)"1.0.3");
    }

    private Copy _addTaskImportFiles(final Project project) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)IMPORT_FILES_TASK_NAME, Copy.class);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        DependencyHandler dependencyHandler = project.getDependencies();
        Properties properties = GUtil.loadProperties((File)project.file((Object)"imported-files.properties"));
        for (String dependencyNotation : properties.stringPropertyNames()) {
            final String dependencyIncludes = properties.getProperty(dependencyNotation);
            Dependency dependency = dependencyHandler.create((Object)dependencyNotation);
            final Configuration configuration = configurationContainer.detachedConfiguration(new Dependency[]{dependency});
            configuration.setTransitive(false);
            copy.from((Object)new Callable<FileTree>(){

                @Override
                public FileTree call() throws Exception {
                    return project.zipTree((Object)configuration.getSingleFile());
                }
            }, (Closure)new Closure<Void>((Object)copy){

                public void doCall(CopySpec copySpec) {
                    copySpec.include(dependencyIncludes.split(","));
                }
            });
        }
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                JavaCompile javaCompile = (JavaCompile)GradleUtil.getTask((Project)project, (String)"compileJava");
                return javaCompile.getDestinationDir();
            }
        });
        return copy;
    }

    private JavaExec _addTaskTransformImportedFiles(final Copy importFilesTask, Configuration bytecodeTransformerConfiguration) {
        JavaExec javaExec = (JavaExec)GradleUtil.addTask((Project)importFilesTask.getProject(), (String)TRANSFORM_IMPORTED_FILES_TASK_NAME, JavaExec.class);
        javaExec.dependsOn(new Object[]{importFilesTask});
        javaExec.setClasspath((FileCollection)bytecodeTransformerConfiguration);
        javaExec.setDescription("Processes imported classes using the Liferay Portal Tools Portal Compat Bytecode Transformer.");
        javaExec.setMain("com.liferay.portal.tools.portal.compat.bytecode.transformer.PortalCompatBytecodeTransformer");
        javaExec.systemProperty("classes.dir", new Object(){

            public String toString() {
                return FileUtil.getAbsolutePath((File)importFilesTask.getDestinationDir());
            }
        });
        return javaExec;
    }

    private void _configureLiferay(Project project, File portalRootDir) {
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        liferayExtension.setDeployDir((Object)new File(portalRootDir, "tmp/lib-pre"));
    }

    private void _configureTaskClasses(JavaExec transformImportedFilesTask) {
        Task classesTask = GradleUtil.getTask((Project)transformImportedFilesTask.getProject(), (String)"classes");
        classesTask.dependsOn(new Object[]{transformImportedFilesTask});
    }

    private void _configureTaskImportFiles(Copy importFilesTask) {
        importFilesTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                DependencyHandler dependencyHandler = project.getDependencies();
                Properties properties = GUtil.loadProperties((File)project.file((Object)"imported-files.properties"));
                for (String key : properties.stringPropertyNames()) {
                    Dependency dependency = dependencyHandler.create((Object)key);
                    String dependencyVersion = dependency.getVersion();
                    Version version = null;
                    try {
                        version = Version.parseVersion((String)dependencyVersion);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new GradleException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
                    }
                    if (!version.isSnapshot()) continue;
                    throw new GradleException("The dependency " + key + " must not be a snapshot");
                }
            }
        });
    }

    private void _configureTaskUpdateFileVersions(Project project, File portalRootDir) {
        String bundleSymbolicName = GradleUtil.getArchivesBaseName(project);
        final Pattern pattern = Pattern.compile(Pattern.quote(bundleSymbolicName) + "-(\\d.+?)\\.jar");
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.getTask((Project)project, (String)"updateFileVersions");
        replaceRegexTask.match(pattern.pattern(), new File(portalRootDir, "build.properties"));
        replaceRegexTask.setReplaceOnlyIf(new Closure<Boolean>((Object)replaceRegexTask){

            public Boolean doCall(String group, String replacement, String content, File contentFile) {
                Matcher matcher = pattern.matcher(content);
                if (!matcher.matches()) {
                    return Boolean.TRUE;
                }
                VersionNumber groupVersionNumber = VersionNumber.parse((String)group);
                VersionNumber replacementVersionNumber = VersionNumber.parse((String)replacement);
                if (groupVersionNumber.getMajor() != replacementVersionNumber.getMajor()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }
}

