/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.LiferayAntPlugin;
import com.liferay.gradle.plugins.LiferayThemePlugin;
import com.liferay.gradle.plugins.cache.CacheExtension;
import com.liferay.gradle.plugins.cache.CachePlugin;
import com.liferay.gradle.plugins.cache.WriteDigestTask;
import com.liferay.gradle.plugins.cache.task.TaskCache;
import com.liferay.gradle.plugins.change.log.builder.BuildChangeLogTask;
import com.liferay.gradle.plugins.change.log.builder.ChangeLogBuilderPlugin;
import com.liferay.gradle.plugins.defaults.LiferayOSGiDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.LiferayThemeDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GitUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.internal.util.LiferayRelengUtil;
import com.liferay.gradle.plugins.defaults.task.MergeFilesTask;
import com.liferay.gradle.plugins.defaults.task.ReplaceRegexTask;
import com.liferay.gradle.plugins.defaults.task.WriteArtifactPublishCommandsTask;
import com.liferay.gradle.plugins.defaults.task.WritePropertiesTask;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.Upload;
import org.gradle.util.CollectionUtils;

public class LiferayRelengPlugin
implements Plugin<Project> {
    public static final String CLEAN_ARTIFACTS_PUBLISH_COMMANDS_TASK_NAME = "cleanArtifactsPublishCommands";
    public static final Plugin<Project> INSTANCE = new LiferayRelengPlugin();
    public static final String MERGE_ARTIFACTS_PUBLISH_COMMANDS = "mergeArtifactsPublishCommands";
    public static final String PRINT_DEPENDENT_ARTIFACT_TASK_NAME = "printDependentArtifact";
    public static final String PRINT_STALE_ARTIFACT_TASK_NAME = "printStaleArtifact";
    public static final String RECORD_ARTIFACT_TASK_NAME = "recordArtifact";
    public static final String UPDATE_VERSION_TASK_NAME = "updateVersion";
    public static final String WRITE_ARTIFACT_PUBLISH_COMMANDS = "writeArtifactPublishCommands";
    protected static final String RELENG_IGNORE_FILE_NAME = ".lfrbuild-releng-ignore";
    private static final String _LIFERAY_RELENG_APP_TITLE_PREFIX = "liferay.releng.app.title.prefix";
    private static final String _LIFERAY_RELENG_PUBLIC = "liferay.releng.public";
    private static final String _LIFERAY_RELENG_SUPPORTED = "liferay.releng.supported";

    public void apply(final Project project) {
        GradleUtil.applyPlugin((Project)project, ChangeLogBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration archivesConfiguration = configurationContainer.getByName("archives");
        TaskProvider printDependentArtifactTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)PRINT_DEPENDENT_ARTIFACT_TASK_NAME, Task.class);
        final TaskProvider printStaleArtifactTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)PRINT_STALE_ARTIFACT_TASK_NAME, Task.class);
        final TaskProvider recordArtifactTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)RECORD_ARTIFACT_TASK_NAME, WritePropertiesTask.class);
        final TaskProvider writeArtifactPublishCommandsTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)WRITE_ARTIFACT_PUBLISH_COMMANDS, WriteArtifactPublishCommandsTask.class);
        TaskProvider<Delete> cleanArtifactsPublishCommandsTaskProvider = this._getTaskCleanArtifactsPublishCommandsProvider(project.getGradle());
        TaskProvider<MergeFilesTask> mergeArtifactsPublishCommandsTaskProvider = this._getTaskMergeArtifactsPublishCommandsProvider(project.getGradle(), cleanArtifactsPublishCommandsTaskProvider, (TaskProvider<WriteArtifactPublishCommandsTask>)writeArtifactPublishCommandsTaskProvider);
        final TaskProvider buildChangeLogTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"buildChangeLog", BuildChangeLogTask.class);
        TaskProvider uploadArchivesTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"uploadArchives", Upload.class);
        File relengDir = LiferayRelengUtil.getRelengDir(project);
        this._configureTaskBuildChangeLogProvider((TaskProvider<BuildChangeLogTask>)buildChangeLogTaskProvider, relengDir);
        this._configureTaskPrintDependentArtifactProvider((TaskProvider<Task>)printDependentArtifactTaskProvider);
        this._configureTaskPrintStaleArtifactProvider(project, (TaskProvider<WritePropertiesTask>)recordArtifactTaskProvider, (TaskProvider<Task>)printStaleArtifactTaskProvider);
        this._configureTaskRecordArtifactProvider(project, (TaskProvider<WritePropertiesTask>)recordArtifactTaskProvider, relengDir);
        this._configureTaskUploadArchivesProvider((TaskProvider<WritePropertiesTask>)recordArtifactTaskProvider, (TaskProvider<Upload>)uploadArchivesTaskProvider);
        this._configureTaskWriteArtifactPublishCommandsProvider(project, cleanArtifactsPublishCommandsTaskProvider, mergeArtifactsPublishCommandsTaskProvider, (TaskProvider<WritePropertiesTask>)recordArtifactTaskProvider, (TaskProvider<WriteArtifactPublishCommandsTask>)writeArtifactPublishCommandsTaskProvider);
        this._configureProperties(project);
        PublishArtifactSet publishArtifactSet = archivesConfiguration.getArtifacts();
        publishArtifactSet.all((Action)new Action<PublishArtifact>(){

            public void execute(PublishArtifact publishArtifact) {
                LiferayRelengPlugin.this._configureTaskRecordArtifactProvider(project, (TaskProvider<WritePropertiesTask>)recordArtifactTaskProvider, publishArtifact);
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                TaskProvider processResourcesTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"processResources", Copy.class);
                LiferayRelengPlugin.this._configureTaskProcessResourcesProvider(project, (TaskProvider<BuildChangeLogTask>)buildChangeLogTaskProvider, (TaskProvider<Copy>)processResourcesTaskProvider);
            }
        });
        pluginContainer.withType(LiferayOSGiDefaultsPlugin.class, (Action)new Action<LiferayOSGiDefaultsPlugin>(){

            public void execute(LiferayOSGiDefaultsPlugin liferayOSGiDefaultsPlugin) {
                LiferayRelengPlugin.this._configureTaskPrintStaleArtifactProviderForLiferayOSGiDefaultsPlugin((TaskProvider<Task>)printStaleArtifactTaskProvider);
                LiferayRelengPlugin.this._configureTaskWriteArtifactPublishCommandsProviderForLiferayOSGiDefaultsPlugin((TaskProvider<WriteArtifactPublishCommandsTask>)writeArtifactPublishCommandsTaskProvider);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayRelengPlugin.this._configureTaskWriteArtifactPublishCommandsProviderAfterEvaluate(project, (TaskProvider<WriteArtifactPublishCommandsTask>)writeArtifactPublishCommandsTaskProvider);
            }
        });
    }

    private LiferayRelengPlugin() {
    }

    private void _configureProperties(Project project) {
        String liferayRelengSupported;
        String liferayRelengPublic;
        String liferayRelengAppTitlePrefix;
        boolean privateModule = false;
        String projectPath = project.getPath();
        if (projectPath.startsWith(":dxp:") || projectPath.startsWith(":private:")) {
            privateModule = true;
        }
        if (Validator.isNull((String)(liferayRelengAppTitlePrefix = GradleUtil.getProperty((ExtensionAware)project, (String)_LIFERAY_RELENG_APP_TITLE_PREFIX, (String)null)))) {
            liferayRelengAppTitlePrefix = privateModule ? "Liferay" : "Liferay CE";
            GradleUtil.setProperty((ExtensionAware)project, (String)_LIFERAY_RELENG_APP_TITLE_PREFIX, (Object)liferayRelengAppTitlePrefix);
        }
        if (Validator.isNull((String)(liferayRelengPublic = GradleUtil.getProperty((ExtensionAware)project, (String)_LIFERAY_RELENG_PUBLIC, (String)null)))) {
            liferayRelengPublic = String.valueOf(!privateModule);
            GradleUtil.setProperty((ExtensionAware)project, (String)_LIFERAY_RELENG_PUBLIC, (Object)liferayRelengPublic);
        }
        if (Validator.isNull((String)(liferayRelengSupported = GradleUtil.getProperty((ExtensionAware)project, (String)_LIFERAY_RELENG_SUPPORTED, (String)null)))) {
            liferayRelengSupported = String.valueOf(privateModule);
            GradleUtil.setProperty((ExtensionAware)project, (String)_LIFERAY_RELENG_SUPPORTED, (Object)liferayRelengSupported);
        }
    }

    private void _configureTaskBuildChangeLogProvider(TaskProvider<BuildChangeLogTask> buildChangeLogTaskProvider, final File relengDir) {
        buildChangeLogTaskProvider.configure((Action)new Action<BuildChangeLogTask>(){

            public void execute(BuildChangeLogTask buildChangeLogTask) {
                String ticketIdPrefixes = GradleUtil.getProperty((ExtensionAware)buildChangeLogTask.getProject(), (String)"jira.project.keys", (String)null);
                if (Validator.isNotNull((String)ticketIdPrefixes)) {
                    buildChangeLogTask.ticketIdPrefixes(ticketIdPrefixes.split(","));
                }
                buildChangeLogTask.setChangeLogFile((Object)new File(relengDir, "liferay-releng.changelog"));
            }
        });
    }

    private void _configureTaskEnabledIfRelease(Task task) {
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Project project = task.getProject();
                return GradleUtil.hasStartParameterTask(project, task.getName()) || !GradlePluginsDefaultsUtil.isSnapshot(project);
            }
        });
    }

    private void _configureTaskPrintDependentArtifactProvider(TaskProvider<Task> printDependentArtifactTaskProvider) {
        printDependentArtifactTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task printDependentArtifactTask) {
                printDependentArtifactTask.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        Project project = task.getProject();
                        File projectDir = project.getProjectDir();
                        System.out.println(projectDir.getAbsolutePath());
                    }
                });
                Spec<Task> onlyIfSpec = new Spec<Task>(){

                    public boolean isSatisfiedBy(Task task) {
                        Pattern pattern;
                        Matcher matcher;
                        Project project = task.getProject();
                        String ignoreProjectRegex = GradleUtil.getTaskPrefixedProperty((Task)task, (String)"ignore.project.regex");
                        if (Validator.isNotNull((String)ignoreProjectRegex) && (matcher = (pattern = Pattern.compile(ignoreProjectRegex)).matcher(project.getName())).find()) {
                            return false;
                        }
                        String result = GitUtil.getGitResult(project, "ls-files", FileUtil.getAbsolutePath((File)project.getProjectDir()));
                        if (Validator.isNull((String)result) || GradlePluginsDefaultsUtil.isTestProject(project)) {
                            return false;
                        }
                        String dependencyName = LiferayRelengUtil.getUnpublishedDependencyName(project);
                        if (dependencyName == null) {
                            return false;
                        }
                        Logger logger = project.getLogger();
                        if (logger.isQuietEnabled()) {
                            logger.quiet("The project dependency '{}' has new commits.", new Object[]{dependencyName});
                        }
                        return true;
                    }
                };
                printDependentArtifactTask.onlyIf((Spec)onlyIfSpec);
                printDependentArtifactTask.setDescription("Prints the project directory if this project contains dependencies to other projects.");
                printDependentArtifactTask.setGroup("verification");
            }
        });
    }

    private void _configureTaskPrintStaleArtifactOnlyIf(Project project, Task printStaleArtifactTask, final WritePropertiesTask recordArtifactTask) {
        final boolean liferayThemeProject = GradleUtil.hasPlugin(project, LiferayThemeDefaultsPlugin.class);
        if (liferayThemeProject && GradlePluginsDefaultsUtil.hasNPMParentThemesDependencies(project)) {
            printStaleArtifactTask.dependsOn(new Object[]{"npmInstall"});
        }
        Spec<Task> onlyIfSpec = new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                File relengIgnoreDir;
                Pattern pattern;
                Matcher matcher;
                Project project = task.getProject();
                String ignoreProjectRegex = GradleUtil.getTaskPrefixedProperty((Task)task, (String)"ignore.project.regex");
                if (Validator.isNotNull((String)ignoreProjectRegex) && (matcher = (pattern = Pattern.compile(ignoreProjectRegex)).matcher(project.getName())).find()) {
                    return false;
                }
                File gitRepoDir = GradleUtil.getRootDir((Project)project, (String)".gitrepo");
                if (gitRepoDir != null) {
                    File file = new File(gitRepoDir, ".gitrepo");
                    try {
                        if (!FileUtil.contains(file, "mode = push")) {
                            return false;
                        }
                    }
                    catch (IOException ioException) {
                        throw new UncheckedIOException(ioException);
                    }
                }
                if ((relengIgnoreDir = GradleUtil.getRootDir((Project)project, (String)LiferayRelengPlugin.RELENG_IGNORE_FILE_NAME)) != null) {
                    return false;
                }
                String result = GitUtil.getGitResult(project, "ls-files", FileUtil.getAbsolutePath((File)project.getProjectDir()));
                if (Validator.isNull((String)result)) {
                    return false;
                }
                if (liferayThemeProject && LiferayRelengUtil.hasStaleParentTheme(project) || LiferayRelengUtil.hasUnpublishedCommits(project, project.getProjectDir(), recordArtifactTask.getOutputFile())) {
                    return true;
                }
                return LiferayRelengUtil.hasStaleUnstyledTheme(project, recordArtifactTask.getOutputFile());
            }
        };
        printStaleArtifactTask.onlyIf((Spec)onlyIfSpec);
    }

    private void _configureTaskPrintStaleArtifactProvider(final Project project, final TaskProvider<WritePropertiesTask> recordArtifactTaskProvider, TaskProvider<Task> printStaleArtifactTaskProvider) {
        printStaleArtifactTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task printStaleArtifactTask) {
                printStaleArtifactTask.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        Project project = task.getProject();
                        File projectDir = project.getProjectDir();
                        System.out.println(projectDir.getAbsolutePath());
                    }
                });
                printStaleArtifactTask.setDescription("Prints the project directory if this project has been changed since the last publish.");
                printStaleArtifactTask.setGroup("verification");
                LiferayRelengPlugin.this._configureTaskPrintStaleArtifactOnlyIf(project, printStaleArtifactTask, (WritePropertiesTask)((Object)recordArtifactTaskProvider.get()));
            }
        });
    }

    private void _configureTaskPrintStaleArtifactProviderForLiferayOSGiDefaultsPlugin(TaskProvider<Task> printStaleArtifactTaskProvider) {
        printStaleArtifactTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task printStaleArtifactTask) {
                if (GradlePluginsDefaultsUtil.isTestProject(printStaleArtifactTask.getProject())) {
                    printStaleArtifactTask.setEnabled(false);
                }
            }
        });
    }

    private void _configureTaskProcessResourcesProvider(final Project project, final TaskProvider<BuildChangeLogTask> buildChangeLogTaskProvider, TaskProvider<Copy> processResourcesTaskProvider) {
        processResourcesTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy processResourcesCopy) {
                processResourcesCopy.from((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        BuildChangeLogTask buildChangeLogTask = (BuildChangeLogTask)buildChangeLogTaskProvider.get();
                        return buildChangeLogTask.getChangeLogFile();
                    }
                }, (Closure)new Closure<Void>((Object)project){

                    public void doCall(CopySpec copySpec) {
                        copySpec.into((Object)"META-INF");
                    }
                });
            }
        });
    }

    private void _configureTaskRecordArtifactProvider(final Project project, TaskProvider<WritePropertiesTask> recordArtifactTaskProvider, final File relengDir) {
        recordArtifactTaskProvider.configure((Action)new Action<WritePropertiesTask>(){

            public void execute(WritePropertiesTask recordArtifactWritePropertiesTask) {
                recordArtifactWritePropertiesTask.property("artifact.git.id", (Object)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return GitUtil.getGitResult(project, "rev-parse", "HEAD");
                    }
                });
                recordArtifactWritePropertiesTask.setDescription("Records the commit ID and the artifact URLs.");
                recordArtifactWritePropertiesTask.setOutputFile(new File(relengDir, "artifact.properties"));
            }
        });
    }

    private void _configureTaskRecordArtifactProvider(final Project project, TaskProvider<WritePropertiesTask> recordArtifactTaskProvider, final PublishArtifact publishArtifact) {
        WritePropertiesTask recordArtifactWritePropertiesTask = (WritePropertiesTask)((Object)recordArtifactTaskProvider.get());
        recordArtifactWritePropertiesTask.property(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String key = publishArtifact.getClassifier();
                if (Validator.isNull((String)key) && ("jar".equals(key = publishArtifact.getType()) && GradleUtil.hasPlugin(project, JavaPlugin.class) || "war".equals(key) && (GradleUtil.hasPlugin(project, LiferayAntPlugin.class) || GradleUtil.hasPlugin(project, LiferayThemePlugin.class)))) {
                    key = null;
                }
                if (Validator.isNull((String)key)) {
                    return "artifact.url";
                }
                return "artifact." + key + ".url";
            }
        }, (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return LiferayRelengUtil.getArtifactRemoteURL(project, publishArtifact, true);
            }
        });
    }

    private void _configureTaskUploadArchivesProvider(final TaskProvider<WritePropertiesTask> recordArtifactTaskProvider, TaskProvider<Upload> uploadArchivesTaskProvider) {
        uploadArchivesTaskProvider.configure((Action)new Action<Upload>(){

            public void execute(Upload uploadArchivesUpload) {
                uploadArchivesUpload.dependsOn(new Object[]{recordArtifactTaskProvider});
                LiferayRelengPlugin.this._configureTaskEnabledIfRelease((Task)recordArtifactTaskProvider.get());
            }
        });
    }

    private void _configureTaskWriteArtifactPublishCommandsOnlyIf(Project project, WriteArtifactPublishCommandsTask writeArtifactPublishCommandsTask, final WritePropertiesTask recordArtifactTask) {
        final String force = GradleUtil.getTaskPrefixedProperty((Task)writeArtifactPublishCommandsTask, (String)"force");
        final boolean liferayThemeProject = GradleUtil.hasPlugin(project, LiferayThemeDefaultsPlugin.class);
        if (liferayThemeProject && GradlePluginsDefaultsUtil.hasNPMParentThemesDependencies(project)) {
            writeArtifactPublishCommandsTask.dependsOn(new Object[]{"npmInstall"});
        }
        Spec<Task> onlyIfSpec = new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                File relengIgnoreDir;
                Pattern pattern;
                Matcher matcher;
                Project project = task.getProject();
                String ignoreProjectRegex = GradleUtil.getTaskPrefixedProperty((Task)task, (String)"ignore.project.regex");
                if (Validator.isNotNull((String)ignoreProjectRegex) && (matcher = (pattern = Pattern.compile(ignoreProjectRegex)).matcher(project.getName())).find()) {
                    return false;
                }
                File gitRepoDir = GradleUtil.getRootDir((Project)project, (String)".gitrepo");
                if (gitRepoDir != null) {
                    File file = new File(gitRepoDir, ".gitrepo");
                    try {
                        if (!FileUtil.contains(file, "mode = push")) {
                            return false;
                        }
                    }
                    catch (IOException ioException) {
                        throw new UncheckedIOException(ioException);
                    }
                }
                if ((relengIgnoreDir = GradleUtil.getRootDir((Project)project, (String)LiferayRelengPlugin.RELENG_IGNORE_FILE_NAME)) != null) {
                    return false;
                }
                String result = GitUtil.getGitResult(project, "ls-files", FileUtil.getAbsolutePath((File)project.getProjectDir()));
                if (Validator.isNull((String)result)) {
                    return false;
                }
                if (Boolean.parseBoolean(force) || liferayThemeProject && LiferayRelengUtil.hasStaleParentTheme(project)) {
                    return true;
                }
                if (LiferayRelengUtil.hasStalePortalDependencies(project, recordArtifactTask.getOutputFile()) || LiferayRelengUtil.hasStaleUnstyledTheme(project, recordArtifactTask.getOutputFile())) {
                    return true;
                }
                if (LiferayRelengUtil.hasUnpublishedCommits(project, project.getProjectDir(), recordArtifactTask.getOutputFile())) {
                    String dependencyName = LiferayRelengUtil.getUnpublishedDependencyName(project);
                    if (dependencyName != null) {
                        Logger logger = project.getLogger();
                        if (logger.isInfoEnabled()) {
                            logger.info("The project dependency '{}' has new commits.", (Object)dependencyName);
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        writeArtifactPublishCommandsTask.onlyIf((Spec)onlyIfSpec);
    }

    private void _configureTaskWriteArtifactPublishCommandsProvider(final Project project, final TaskProvider<Delete> cleanArtifactsPublishCommandsTaskProvider, final TaskProvider<MergeFilesTask> mergeArtifactsPublishCommandsTaskProvider, final TaskProvider<WritePropertiesTask> recordArtifactTaskProvider, TaskProvider<WriteArtifactPublishCommandsTask> writeArtifactPublishCommandsTaskProvider) {
        writeArtifactPublishCommandsTaskProvider.configure((Action)new Action<WriteArtifactPublishCommandsTask>(){

            public void execute(WriteArtifactPublishCommandsTask writeArtifactPublishCommandsTask) {
                writeArtifactPublishCommandsTask.dependsOn(new Object[]{cleanArtifactsPublishCommandsTaskProvider});
                writeArtifactPublishCommandsTask.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        Project project = task.getProject();
                        Gradle gradle = project.getGradle();
                        StartParameter startParameter = gradle.getStartParameter();
                        if (startParameter.isParallelProjectExecutionEnabled()) {
                            throw new GradleException("Unable to run " + task + " in parallel");
                        }
                    }
                });
                writeArtifactPublishCommandsTask.finalizedBy(new Object[]{mergeArtifactsPublishCommandsTaskProvider});
                writeArtifactPublishCommandsTask.setArtifactPropertiesFile(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        WritePropertiesTask recordArtifactWritePropertiesTask = (WritePropertiesTask)((Object)recordArtifactTaskProvider.get());
                        return recordArtifactWritePropertiesTask.getOutputFile();
                    }
                });
                writeArtifactPublishCommandsTask.setDescription("Prints the artifact publish commands if this project has been changed since the last publish.");
                Delete cleanArtifactsPublishCommandsDelete = (Delete)cleanArtifactsPublishCommandsTaskProvider.get();
                writeArtifactPublishCommandsTask.setOutputDir(CollectionUtils.first((Iterable)cleanArtifactsPublishCommandsDelete.getDelete()));
                LiferayRelengPlugin.this._configureTaskWriteArtifactPublishCommandsOnlyIf(project, writeArtifactPublishCommandsTask, (WritePropertiesTask)((Object)recordArtifactTaskProvider.get()));
            }
        });
    }

    private void _configureTaskWriteArtifactPublishCommandsProviderAfterEvaluate(Project project, TaskProvider<WriteArtifactPublishCommandsTask> writeArtifactPublishCommandsTaskProvider) {
        WriteArtifactPublishCommandsTask writeArtifactPublishCommandsTask;
        TaskProvider updateVersionTaskProvider = GradleUtil.fetchTaskProvider((Project)project, (String)UPDATE_VERSION_TASK_NAME, ReplaceRegexTask.class);
        if (updateVersionTaskProvider != null) {
            ReplaceRegexTask updateVersionReplaceRegexTask = (ReplaceRegexTask)((Object)updateVersionTaskProvider.get());
            Map<String, FileCollection> matches = updateVersionReplaceRegexTask.getMatches();
            WriteArtifactPublishCommandsTask writeArtifactPublishCommandsTask2 = (WriteArtifactPublishCommandsTask)((Object)writeArtifactPublishCommandsTaskProvider.get());
            writeArtifactPublishCommandsTask2.prepNextFiles(matches.values());
        }
        if (GradleUtil.hasPlugin(project, CachePlugin.class)) {
            CacheExtension cacheExtension = (CacheExtension)GradleUtil.getExtension((ExtensionAware)project, CacheExtension.class);
            writeArtifactPublishCommandsTask = (WriteArtifactPublishCommandsTask)((Object)writeArtifactPublishCommandsTaskProvider.get());
            for (TaskCache taskCache : cacheExtension.getTasks()) {
                writeArtifactPublishCommandsTask.prepNextFiles(new File(taskCache.getCacheDir(), ".digest"));
            }
        }
        if (GradleUtil.hasPlugin(project, LiferayThemeDefaultsPlugin.class)) {
            TaskProvider writeParentThemesDigestTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"writeParentThemesDigest", WriteDigestTask.class);
            writeArtifactPublishCommandsTask = (WriteArtifactPublishCommandsTask)((Object)writeArtifactPublishCommandsTaskProvider.get());
            WriteDigestTask writeParentThemesDigestWriteDigestTask = (WriteDigestTask)writeParentThemesDigestTaskProvider.get();
            writeArtifactPublishCommandsTask.prepNextCommitFile("digest", writeParentThemesDigestWriteDigestTask.getDigestFile());
        }
    }

    private void _configureTaskWriteArtifactPublishCommandsProviderForLiferayOSGiDefaultsPlugin(TaskProvider<WriteArtifactPublishCommandsTask> writeArtifactPublishCommandsTaskProvider) {
        writeArtifactPublishCommandsTaskProvider.configure((Action)new Action<WriteArtifactPublishCommandsTask>(){

            public void execute(WriteArtifactPublishCommandsTask writeArtifactPublishCommandsTask) {
                if (GradlePluginsDefaultsUtil.isTestProject(writeArtifactPublishCommandsTask.getProject())) {
                    writeArtifactPublishCommandsTask.setEnabled(false);
                }
                writeArtifactPublishCommandsTask.setFirstPublishExcludedTaskName("updateFileVersions");
            }
        });
    }

    private TaskProvider<Delete> _getTaskCleanArtifactsPublishCommandsProvider(Gradle gradle) {
        StartParameter startParameter = gradle.getStartParameter();
        final Project currentProject = GradleUtil.getProject((Project)gradle.getRootProject(), (File)startParameter.getCurrentDir());
        TaskProvider cleanArtifactsPublishCommandsTaskProvider = GradleUtil.fetchTaskProvider((Project)currentProject, (String)CLEAN_ARTIFACTS_PUBLISH_COMMANDS_TASK_NAME, Delete.class);
        if (cleanArtifactsPublishCommandsTaskProvider != null) {
            return cleanArtifactsPublishCommandsTaskProvider;
        }
        cleanArtifactsPublishCommandsTaskProvider = GradleUtil.addTaskProvider((Project)currentProject, (String)CLEAN_ARTIFACTS_PUBLISH_COMMANDS_TASK_NAME, Delete.class);
        cleanArtifactsPublishCommandsTaskProvider.configure((Action)new Action<Delete>(){

            public void execute(Delete cleanArtifactsPublishCommandsDelete) {
                cleanArtifactsPublishCommandsDelete.delete(new Object[]{new File(currentProject.getBuildDir(), "artifacts-publish-commands")});
                cleanArtifactsPublishCommandsDelete.setDescription("Deletes the temporary directory that contains the artifacts publish commands.");
            }
        });
        return cleanArtifactsPublishCommandsTaskProvider;
    }

    private TaskProvider<MergeFilesTask> _getTaskMergeArtifactsPublishCommandsProvider(Gradle gradle, final TaskProvider<Delete> cleanArtifactsPublishCommandsTaskProvider, final TaskProvider<WriteArtifactPublishCommandsTask> writeArtifactPublishCommandsTaskProvider) {
        StartParameter startParameter = gradle.getStartParameter();
        final Project currentProject = GradleUtil.getProject((Project)gradle.getRootProject(), (File)startParameter.getCurrentDir());
        TaskProvider mergeArtifactsPublishCommandsTaskProvider = GradleUtil.fetchTaskProvider((Project)currentProject, (String)MERGE_ARTIFACTS_PUBLISH_COMMANDS, MergeFilesTask.class);
        if (mergeArtifactsPublishCommandsTaskProvider != null) {
            return mergeArtifactsPublishCommandsTaskProvider;
        }
        mergeArtifactsPublishCommandsTaskProvider = GradleUtil.addTaskProvider((Project)currentProject, (String)MERGE_ARTIFACTS_PUBLISH_COMMANDS, MergeFilesTask.class);
        mergeArtifactsPublishCommandsTaskProvider.configure((Action)new Action<MergeFilesTask>(){

            public void execute(MergeFilesTask mergeArtifactsPublishCommandsMergeFilesTask) {
                mergeArtifactsPublishCommandsMergeFilesTask.mustRunAfter(new Object[]{writeArtifactPublishCommandsTaskProvider});
                Delete cleanArtifactsPublishCommandsDelete = (Delete)cleanArtifactsPublishCommandsTaskProvider.get();
                File dir = GradleUtil.toFile((Project)currentProject, (Object)CollectionUtils.first((Iterable)cleanArtifactsPublishCommandsDelete.getDelete()));
                mergeArtifactsPublishCommandsMergeFilesTask.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        MergeFilesTask mergeFilesTask = (MergeFilesTask)task;
                        Logger logger = mergeFilesTask.getLogger();
                        File file = mergeFilesTask.getOutputFile();
                        if (file.exists()) {
                            boolean success = file.setExecutable(true);
                            if (!success) {
                                logger.error("Unable to set the owner's execute permission for {}", (Object)file);
                            }
                            if (logger.isQuietEnabled()) {
                                logger.quiet("Artifacts publish commands written in {}.", new Object[]{file});
                            }
                        } else if (logger.isQuietEnabled()) {
                            logger.quiet("No artifacts publish commands are available.");
                        }
                    }
                });
                mergeArtifactsPublishCommandsMergeFilesTask.setDescription("Merges the artifacts publish commands.");
                mergeArtifactsPublishCommandsMergeFilesTask.setHeader("#!/bin/bash" + System.lineSeparator() + System.lineSeparator() + "set -e" + System.lineSeparator());
                mergeArtifactsPublishCommandsMergeFilesTask.setInputFiles(new File(dir, "writeArtifactPublishCommands-step3.sh"));
                mergeArtifactsPublishCommandsMergeFilesTask.setOutputFile(new File(dir, "artifacts-publish-commands.sh"));
                TaskOutputsInternal taskOutputs = mergeArtifactsPublishCommandsMergeFilesTask.getOutputs();
                taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

                    public boolean isSatisfiedBy(Task task) {
                        return false;
                    }
                });
            }
        });
        return mergeArtifactsPublishCommandsTaskProvider;
    }
}

