/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util.copy;

import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public class ReplaceContentFilterReader
extends BaseParamFilterReader
implements ChainableReader {
    private static final int _EOF = -1;
    private char[] _buffer;
    private String _from;
    private int _index;
    private boolean _resources;
    private String _to;

    public ReplaceContentFilterReader() {
    }

    public ReplaceContentFilterReader(Reader reader) {
        super(reader);
    }

    public Reader chain(Reader reader) {
        ReplaceContentFilterReader replaceContentFilterReader = new ReplaceContentFilterReader(reader);
        replaceContentFilterReader.setFrom(this._from);
        replaceContentFilterReader.setResources(this._resources);
        replaceContentFilterReader.setTo(this._to);
        replaceContentFilterReader.setInitialized(true);
        return replaceContentFilterReader;
    }

    public String getFrom() {
        return this._from;
    }

    public String getTo() {
        return this._to;
    }

    public boolean isResources() {
        return this._resources;
    }

    public int read() throws IOException {
        if (!this.getInitialized()) {
            this._initialize();
            this.setInitialized(true);
        }
        if (this._index > -1) {
            if (this._buffer == null) {
                String content = this._normalize(this.readFully());
                content = content.replace(this._from, this._to);
                this._buffer = content.toCharArray();
            }
            if (this._index < this._buffer.length) {
                return this._buffer[this._index++];
            }
            this._index = -1;
        }
        return -1;
    }

    public void setFrom(String from) {
        this._from = from;
    }

    public void setResources(boolean resources) {
        this._resources = resources;
    }

    public void setTo(String to) {
        this._to = to;
    }

    private void _initialize() throws IOException {
        Parameter[] parameters = this.getParameters();
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                String name = parameter.getName();
                String value = parameter.getValue();
                if (name.equals("from")) {
                    this.setFrom(value);
                    continue;
                }
                if (name.equals("resources")) {
                    this.setResources(Boolean.parseBoolean(value));
                    continue;
                }
                if (!name.equals("to")) continue;
                this.setTo(value);
            }
        }
        String from = this._from;
        String to = this._to;
        if (this._resources) {
            from = FileUtil.read((String)from);
            to = FileUtil.read((String)to);
        }
        from = this._normalize(from);
        to = this._normalize(to);
        this.setFrom(from);
        this.setTo(to);
    }

    private String _normalize(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\r\n", "\n");
    }
}

