/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.defaults.internal.LiferayCIPatcherPlugin;
import com.liferay.gradle.plugins.defaults.internal.LiferayCIPlugin;
import com.liferay.gradle.plugins.defaults.internal.NodeDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.CIUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.YarnPlugin;
import com.liferay.gradle.plugins.node.tasks.YarnInstallTask;
import com.liferay.gradle.util.Validator;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskProvider;

public class LiferayYarnDefaultsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, YarnPlugin.class);
        GradleUtil.applyPlugin((Project)project, com.liferay.gradle.plugins.NodeDefaultsPlugin.class);
        NodeDefaultsPlugin.INSTANCE.apply((Object)project);
        if (CIUtil.isRunningInCIEnvironment()) {
            LiferayCIPlugin.INSTANCE.apply((Object)project);
        }
        if (CIUtil.isRunningInCIPatcherEnvironment()) {
            LiferayCIPatcherPlugin.INSTANCE.apply((Object)project);
        }
        TaskProvider yarnInstallTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"yarnInstall", YarnInstallTask.class);
        this._configureTaskYarnInstallProvider(project, (TaskProvider<YarnInstallTask>)yarnInstallTaskProvider);
    }

    private void _configureTaskYarnInstallProvider(final Project project, TaskProvider<YarnInstallTask> yarnInstallTaskProvider) {
        yarnInstallTaskProvider.configure((Action)new Action<YarnInstallTask>(){

            public void execute(YarnInstallTask yarnInstallTask) {
                Gradle gradle = project.getGradle();
                StartParameter startParameter = gradle.getStartParameter();
                String buildProfile = System.getProperty("build.profile");
                if (startParameter.isParallelProjectExecutionEnabled() || Validator.isNotNull((String)buildProfile)) {
                    yarnInstallTask.setEnabled(false);
                }
            }
        });
    }
}

