/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.defaults.internal.util.GitRepo;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.poshi.runner.PoshiRunnerResourcesExtension;
import com.liferay.gradle.plugins.poshi.runner.PoshiRunnerResourcesPlugin;
import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class PoshiRunnerResourcesDefaultsPlugin
implements Plugin<Project> {
    public static final String ARTIFACT_APPENDIX_PROPERTY_NAME = "artifactAppendix";
    public static final String ARTIFACT_VERSION_PROPERTY_NAME = "artifactVersion";
    private static final String _GROUP_ID = "com.liferay.poshi.runner.resources";
    private static final String _ROOT_DIR_NAME = "testFunctional";

    public void apply(Project project) {
        GradlePluginsDefaultsUtil.configureRepositories(project, null);
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
        GradleUtil.applyPlugin((Project)project, PoshiRunnerResourcesPlugin.class);
        this._applyConfigScripts(project);
        this._configurePoshiRunnerResources(project);
        this._configureTaskUploadPoshiRunnerResources(project);
    }

    private void _applyConfigScripts(Project project) {
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/defaults/dependencies/config-maven.gradle", (Object)project);
    }

    private void _configurePoshiRunnerResources(Project project) {
        PoshiRunnerResourcesExtension poshiRunnerResourcesExtension = (PoshiRunnerResourcesExtension)GradleUtil.getExtension((ExtensionAware)project, PoshiRunnerResourcesExtension.class);
        poshiRunnerResourcesExtension.setRootDirName((Object)_ROOT_DIR_NAME);
        if (project.hasProperty(ARTIFACT_APPENDIX_PROPERTY_NAME)) {
            String artifactAppendix = GradleUtil.getProperty((ExtensionAware)project, (String)ARTIFACT_APPENDIX_PROPERTY_NAME, (String)null);
            poshiRunnerResourcesExtension.setArtifactAppendix((Object)artifactAppendix);
        }
        if (project.hasProperty(ARTIFACT_VERSION_PROPERTY_NAME)) {
            String artifactVersion = GradleUtil.getProperty((ExtensionAware)project, (String)ARTIFACT_VERSION_PROPERTY_NAME, (String)null);
            poshiRunnerResourcesExtension.setArtifactVersion((Object)artifactVersion);
        }
    }

    private void _configureTaskUploadPoshiRunnerResources(final Project project) {
        Upload upload = (Upload)GradleUtil.getTask((Project)project, (String)"uploadPoshiRunnerResources");
        upload.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                GitRepo gitRepo = GitRepo.getGitRepo(project.getProjectDir());
                return gitRepo == null || !gitRepo.readOnly;
            }
        });
        RepositoryHandler repositoryHandler = upload.getRepositories();
        final MavenDeployer mavenDeployer = (MavenDeployer)repositoryHandler.getAt("mavenDeployer");
        Configuration configuration = upload.getConfiguration();
        PublishArtifactSet publishArtifactSet = configuration.getAllArtifacts();
        publishArtifactSet.withType(ArchivePublishArtifact.class, (Action)new Action<ArchivePublishArtifact>(){

            public void execute(ArchivePublishArtifact archivePublishArtifact) {
                AbstractArchiveTask abstractArchiveTask = archivePublishArtifact.getArchiveTask();
                final String name = abstractArchiveTask.getArchiveName();
                mavenDeployer.addFilter(name, (Closure)new Closure<Boolean>((Object)project){

                    public Boolean doCall(Object artifact, File file) {
                        if (name.equals(file.getName())) {
                            return true;
                        }
                        return false;
                    }
                });
                MavenPom mavenPom = mavenDeployer.pom(name);
                mavenPom.setGroupId(PoshiRunnerResourcesDefaultsPlugin._GROUP_ID);
                mavenPom.setVersion(abstractArchiveTask.getVersion());
            }
        });
    }
}

