/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.liferay.gradle.plugins.cache.WriteDigestTask;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GitUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Upload;
import org.gradle.util.GUtil;
import org.gradle.util.VersionNumber;

public class LiferayRelengUtil {
    private static final String _ARTIFACT_PROPERTIES_FILE_NAME = "artifact.properties";
    private static final String _IGNORED_MESSAGE_PATTERN = "artifact:ignore";
    private static final String _JS_COMPILE_CONFIGURATION_NAME = "jsCompile";
    private static final String _MODULES_DIR_NAME = "modules";
    private static final String _RELENG_DIR_NAME = ".releng";
    private static final String _SOY_COMPILE_CONFIGURATION_NAME = "soyCompile";

    public static String getArtifactRemoteURL(Project project, PublishArtifact publishArtifact, boolean cdn) throws Exception {
        StringBuilder sb = LiferayRelengUtil._getArtifactRemoteBaseURL(project, cdn);
        String name = GradleUtil.getArchivesBaseName(project);
        sb.append(name);
        sb.append('/');
        sb.append(project.getVersion());
        sb.append('/');
        sb.append(name);
        sb.append('-');
        sb.append(project.getVersion());
        String classifier = publishArtifact.getClassifier();
        if (Validator.isNotNull((String)classifier)) {
            sb.append('-');
            sb.append(classifier);
        }
        sb.append('.');
        sb.append(publishArtifact.getExtension());
        return sb.toString();
    }

    public static File getRelengDir(File projectDir) {
        File rootDir = GradleUtil.getRootDir((File)projectDir, (String)_RELENG_DIR_NAME);
        if (rootDir == null) {
            return null;
        }
        File relengDir = new File(rootDir, _RELENG_DIR_NAME);
        return new File(relengDir, FileUtil.relativize((File)projectDir, (File)rootDir));
    }

    public static File getRelengDir(Project project) {
        return LiferayRelengUtil.getRelengDir(project.getProjectDir());
    }

    public static boolean hasStaleParentTheme(Project project) {
        WriteDigestTask writeDigestTask = (WriteDigestTask)GradleUtil.getTask((Project)project, (String)"writeParentThemesDigest");
        if (!Objects.equals(writeDigestTask.getDigest(), writeDigestTask.getOldDigest())) {
            Logger logger = project.getLogger();
            if (logger.isInfoEnabled()) {
                logger.info("The digest for {} has changed.", (Object)writeDigestTask);
            }
            return true;
        }
        return false;
    }

    public static boolean hasStalePortalDependencies(Project project, String artifactGitId) {
        List<File> artifactPropertiesFiles = LiferayRelengUtil._getArtifactPropertiesFiles(project, true);
        for (File artifactPropertiesFile : artifactPropertiesFiles) {
            Properties artifactProperties = GUtil.loadProperties((File)artifactPropertiesFile);
            String artifactUrl = artifactProperties.getProperty("artifact.url");
            if (Validator.isNull((String)artifactUrl)) {
                File artifactProjectDir = LiferayRelengUtil._getArtifactProjectDir(artifactPropertiesFile);
                throw new GradleException("The dependency '" + artifactProjectDir.getName() + "' has never been published");
            }
            String[] tokens = artifactUrl.split("/");
            String compatVersion = GradleUtil.getProperty((ExtensionAware)project, (String)("build.compat.version." + tokens[tokens.length - 3]), (String)null);
            if (Validator.isNotNull((String)compatVersion)) continue;
            VersionNumber artifactVersionNumber = VersionNumber.parse((String)tokens[tokens.length - 2]);
            File artifactProjectDir = LiferayRelengUtil._getArtifactProjectDir(artifactPropertiesFile);
            Properties properties = GUtil.loadProperties((File)new File(artifactProjectDir, "bnd.bnd"));
            VersionNumber versionNumber = VersionNumber.parse((String)properties.getProperty("Bundle-Version"));
            if (versionNumber.getMinor() == artifactVersionNumber.getMinor()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUnpublishedCommits(Project project, File artifactProjectDir, File artifactPropertiesFile) {
        String[] lines;
        String artifactGitId;
        Logger logger = project.getLogger();
        Properties artifactProperties = new Properties();
        if (artifactPropertiesFile.exists()) {
            artifactProperties = GUtil.loadProperties((File)artifactPropertiesFile);
        }
        if (Validator.isNull((String)(artifactGitId = artifactProperties.getProperty("artifact.git.id")))) {
            if (logger.isInfoEnabled()) {
                logger.info("The project '{}' has never been published.", (Object)artifactProjectDir.getName());
            }
            return true;
        }
        Project rootProject = project.getRootProject();
        String gitId = GitUtil.getGitResult(project, rootProject.getProjectDir(), "rev-parse", "--short", "HEAD");
        File gitResultsDir = new File(rootProject.getBuildDir(), "releng/git-results/" + gitId);
        StringBuilder sb = new StringBuilder();
        sb.append(artifactProjectDir.getName());
        sb.append('-');
        sb.append(artifactGitId);
        sb.append('-');
        File file = new File(gitResultsDir, sb.toString() + "true");
        if (file.exists()) {
            return true;
        }
        file = new File(gitResultsDir, sb.toString() + "false");
        if (file.exists()) {
            return false;
        }
        String result = GitUtil.getGitResult(project, artifactProjectDir, "log", "--format=%s", artifactGitId + "..HEAD", ".");
        for (String line : lines = result.split("\\r?\\n")) {
            if (logger.isInfoEnabled()) {
                logger.info("Git Commit: {}", (Object)line);
            }
            if (Validator.isNull((String)line) || line.contains(_IGNORED_MESSAGE_PATTERN)) continue;
            LiferayRelengUtil._createNewFile(new File(gitResultsDir, sb.toString() + "true"));
            return true;
        }
        LiferayRelengUtil._createNewFile(new File(gitResultsDir, sb.toString() + "false"));
        return false;
    }

    public static boolean hasUnpublishedDependencies(Project project) {
        List<File> artifactPropertiesFiles = LiferayRelengUtil._getArtifactPropertiesFiles(project, false);
        for (File artifactPropertiesFile : artifactPropertiesFiles) {
            File artifactProjectDir = LiferayRelengUtil._getArtifactProjectDir(artifactPropertiesFile);
            if (!LiferayRelengUtil.hasUnpublishedCommits(project, artifactProjectDir, artifactPropertiesFile)) continue;
            Logger logger = project.getLogger();
            if (logger.isQuietEnabled()) {
                logger.quiet("The project dependency '{}' has new commits.", new Object[]{artifactProjectDir.getName()});
            }
            return true;
        }
        return false;
    }

    private static void _createNewFile(File file) {
        File dir = file.getParentFile();
        try {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            file.createNewFile();
        }
        catch (IOException ioException) {
            throw new UncheckedIOException(ioException);
        }
    }

    private static File _getArtifactProjectDir(File artifactPropertiesFile) {
        String fileName = artifactPropertiesFile.getName();
        if (Objects.equals(fileName, _ARTIFACT_PROPERTIES_FILE_NAME)) {
            File rootDir;
            File artifactPropertiesDir = artifactPropertiesFile.getParentFile();
            File relengRootDir = GradleUtil.getRootDir((File)artifactPropertiesDir, (String)_RELENG_DIR_NAME);
            while ((rootDir = GradleUtil.getRootDir((File)relengRootDir.getParentFile(), (String)_RELENG_DIR_NAME)) != null) {
                relengRootDir = rootDir;
            }
            File relengDir = new File(relengRootDir, _RELENG_DIR_NAME);
            String relativePath = FileUtil.relativize((File)artifactPropertiesDir, (File)relengDir);
            return new File(relengRootDir, relativePath);
        }
        File portalRootDir = GradleUtil.getRootDir((File)artifactPropertiesFile.getParentFile(), (String)"portal-impl");
        int pos = fileName.lastIndexOf(46);
        return new File(portalRootDir, fileName.substring(0, pos));
    }

    private static List<File> _getArtifactPropertiesFiles(Project project, boolean portalOnly) {
        ArrayList<File> artifactPropertiesFiles = new ArrayList<File>();
        for (Configuration configuration : project.getConfigurations()) {
            String configurationName = configuration.getName();
            if (configurationName.equals(_JS_COMPILE_CONFIGURATION_NAME) || configurationName.equals(_SOY_COMPILE_CONFIGURATION_NAME) || configurationName.startsWith("test")) continue;
            for (Dependency dependency : configuration.getDependencies()) {
                File propertiesFile;
                if (dependency instanceof ProjectDependency) {
                    ProjectDependency projectDependency;
                    File relengDir;
                    if (portalOnly || (relengDir = LiferayRelengUtil.getRelengDir((projectDependency = (ProjectDependency)dependency).getDependencyProject())) == null) continue;
                    File propertiesFile2 = new File(relengDir, _ARTIFACT_PROPERTIES_FILE_NAME);
                    artifactPropertiesFiles.add(propertiesFile2);
                    continue;
                }
                if (!configurationName.startsWith("compile") || (propertiesFile = LiferayRelengUtil._getPortalArtifactPropertiesFile(project, dependency)) == null) continue;
                artifactPropertiesFiles.add(propertiesFile);
            }
        }
        return artifactPropertiesFiles;
    }

    private static StringBuilder _getArtifactRemoteBaseURL(Project project, boolean cdn) throws Exception {
        StringBuilder sb;
        Upload upload = (Upload)GradleUtil.getTask((Project)project, (String)"uploadArchives");
        RepositoryHandler repositoryHandler = upload.getRepositories();
        MavenDeployer mavenDeployer = (MavenDeployer)repositoryHandler.getAt("mavenDeployer");
        Object repository = mavenDeployer.getRepository();
        Class<?> repositoryClass = repository.getClass();
        Method getUrlMethod = repositoryClass.getMethod("getUrl", new Class[0]);
        String url = (String)getUrlMethod.invoke(repository, new Object[0]);
        if (cdn) {
            url = url.replace("repository.liferay.com", "repository-cdn.liferay.com");
        }
        if ((sb = new StringBuilder(url)).charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        String group = String.valueOf(project.getGroup());
        sb.append(group.replace('.', '/'));
        sb.append('/');
        return sb;
    }

    private static File _getPortalArtifactPropertiesFile(Project project, Dependency dependency) {
        String dependencyGroup = dependency.getGroup();
        if (!Objects.equals(dependencyGroup, "com.liferay.portal")) {
            return null;
        }
        String dependencyVersion = dependency.getVersion();
        if (!Objects.equals(dependencyVersion, "default")) {
            return null;
        }
        String dependencyName = dependency.getName();
        if (!dependencyName.startsWith("com.liferay.")) {
            return null;
        }
        File portalRootDir = GradleUtil.getRootDir((Project)project.getRootProject(), (String)"portal-impl");
        if (portalRootDir == null) {
            return null;
        }
        String portalProjectName = dependencyName.substring(12);
        File portalProjectDir = new File(portalRootDir, portalProjectName.replace('.', '-'));
        if (!portalProjectDir.exists()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(_MODULES_DIR_NAME);
        sb.append('/');
        sb.append(_RELENG_DIR_NAME);
        sb.append('/');
        sb.append(portalProjectDir.getName());
        sb.append(".properties");
        return new File(portalRootDir, sb.toString());
    }
}

