/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.jsdoc.JSDocPlugin;
import com.liferay.gradle.plugins.jsdoc.JSDocTask;
import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.tasks.TaskContainer;

public class JSDocDefaultsPlugin
extends BaseDefaultsPlugin<JSDocPlugin> {
    public static final Plugin<Project> INSTANCE = new JSDocDefaultsPlugin();
    private static final String _CONFIG_JSON;

    protected void configureDefaults(Project project, JSDocPlugin jsDocPlugin) {
        this._configureTasksJSDoc(project);
    }

    protected Class<JSDocPlugin> getPluginClass() {
        return JSDocPlugin.class;
    }

    private JSDocDefaultsPlugin() {
    }

    private void _configureTaskJSDoc(JSDocTask jsDocTask) {
        Project project = jsDocTask.getProject();
        ResourceHandler resourceHandler = project.getResources();
        TextResourceFactory textResourceFactory = resourceHandler.getText();
        jsDocTask.setConfiguration(textResourceFactory.fromString(_CONFIG_JSON));
        File readmeFile = project.file((Object)"README.markdown");
        if (readmeFile.exists()) {
            jsDocTask.setReadmeFile((Object)readmeFile);
        }
    }

    private void _configureTasksJSDoc(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(JSDocTask.class, (Action)new Action<JSDocTask>(){

            public void execute(JSDocTask jsDocTask) {
                JSDocDefaultsPlugin.this._configureTaskJSDoc(jsDocTask);
            }
        });
    }

    static {
        try {
            _CONFIG_JSON = FileUtil.read((String)"com/liferay/gradle/plugins/defaults/internal/dependencies/config-jsdoc.json");
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError(ioe);
        }
    }
}

