/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import org.dm.gradle.plugins.bundle.BundleExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.authentication.DefaultBasicAuthentication;

public class GradlePluginsDefaultsUtil {
    public static final String DEFAULT_REPOSITORY_URL = "https://cdn.lfrs.sl/repository.liferay.com/nexus/content/groups/public";
    public static final String[] JSON_VERSION_FILE_NAMES = new String[]{"npm-shrinkwrap.json", "package-lock.json", "package.json"};
    public static final String SNAPSHOT_PROPERTY_NAME = "snapshot";
    public static final String SNAPSHOT_VERSION_SUFFIX = "-SNAPSHOT";
    public static final String TMP_MAVEN_REPOSITORY_DIR_NAME = ".m2-tmp";
    public static final Pattern jsonVersionPattern = Pattern.compile("\\n\\t\"version\": \"(.+)\"");
    private static final String _TEST_PROJECT_SUFFIX = "-test";

    public static void configureRepositories(Project project, File portalRootDir) {
        RepositoryHandler repositoryHandler = project.getRepositories();
        if (!Boolean.getBoolean("maven.local.ignore")) {
            repositoryHandler.mavenLocal();
            File tmpMavenRepositoryDir = null;
            if (portalRootDir != null) {
                tmpMavenRepositoryDir = new File(portalRootDir, TMP_MAVEN_REPOSITORY_DIR_NAME);
            }
            if (tmpMavenRepositoryDir != null && tmpMavenRepositoryDir.exists()) {
                GradleUtil.addMavenArtifactRepository(repositoryHandler, tmpMavenRepositoryDir);
            }
        }
        String url = System.getProperty("repository.url", DEFAULT_REPOSITORY_URL);
        GradleUtil.addMavenArtifactRepository(repositoryHandler, url);
        final String repositoryPrivatePassword = System.getProperty("repository.private.password");
        final String repositoryPrivateUrl = System.getProperty("repository.private.url");
        final String repositoryPrivateUsername = System.getProperty("repository.private.username");
        if (Validator.isNotNull((String)repositoryPrivatePassword) && Validator.isNotNull((String)repositoryPrivateUrl) && Validator.isNotNull((String)repositoryPrivateUsername)) {
            MavenArtifactRepository mavenArtifactRepository = repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

                public void execute(MavenArtifactRepository mavenArtifactRepository) {
                    mavenArtifactRepository.setUrl((Object)repositoryPrivateUrl);
                }
            });
            mavenArtifactRepository.authentication((Action)new Action<AuthenticationContainer>(){

                public void execute(AuthenticationContainer authenticationContainer) {
                    authenticationContainer.add((Object)new DefaultBasicAuthentication("basic"));
                }
            });
            mavenArtifactRepository.credentials((Action)new Action<PasswordCredentials>(){

                public void execute(PasswordCredentials passwordCredentials) {
                    passwordCredentials.setPassword(repositoryPrivatePassword);
                    passwordCredentials.setUsername(repositoryPrivateUsername);
                }
            });
        }
    }

    public static String getBundleInstruction(Project project, String key) {
        Map<String, String> bundleInstructions = GradlePluginsDefaultsUtil.getBundleInstructions(project);
        return bundleInstructions.get(key);
    }

    public static Map<String, String> getBundleInstructions(Project project) {
        BundleExtension bundleExtension = (BundleExtension)GradleUtil.getExtension((ExtensionAware)project, BundleExtension.class);
        return (Map)bundleExtension.getInstructions();
    }

    public static boolean isPrivateProject(Project project) {
        String path = project.getPath();
        return path.startsWith(":private:");
    }

    public static boolean isSnapshot(Project project) {
        String version = String.valueOf(project.getVersion());
        return version.endsWith(SNAPSHOT_VERSION_SUFFIX);
    }

    public static boolean isSnapshot(Project project, String ... propertyNames) {
        boolean snapshot = false;
        if (project.hasProperty(SNAPSHOT_PROPERTY_NAME)) {
            snapshot = GradleUtil.getProperty((ExtensionAware)project, (String)SNAPSHOT_PROPERTY_NAME, (boolean)true);
        }
        if (!snapshot) {
            for (String propertyName : propertyNames) {
                if (!project.hasProperty(propertyName) || !GradleUtil.getProperty((ExtensionAware)project, (String)propertyName, (boolean)true)) continue;
                snapshot = true;
                break;
            }
        }
        return snapshot;
    }

    public static boolean isTestProject(File dir) {
        String dirName = dir.getName();
        return dirName.endsWith(_TEST_PROJECT_SUFFIX);
    }

    public static boolean isTestProject(Project project) {
        String projectName = project.getName();
        return projectName.endsWith(_TEST_PROJECT_SUFFIX);
    }

    public static void setProjectSnapshotVersion(Project project, String ... propertyNames) {
        String version = String.valueOf(project.getVersion());
        if (GradlePluginsDefaultsUtil.isSnapshot(project, propertyNames) && !version.endsWith(SNAPSHOT_VERSION_SUFFIX)) {
            project.setVersion((Object)(version + SNAPSHOT_VERSION_SUFFIX));
        }
    }
}

