/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.LiferayRelengPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.MavenPlugin;

public class MavenDefaultsPlugin
extends BaseDefaultsPlugin<MavenPlugin> {
    public static final Plugin<Project> INSTANCE = new MavenDefaultsPlugin();
    protected static final Action<Task> failReleaseOnWrongBranchAction = new Action<Task>(){

        public void execute(Task task) {
            Project project = task.getProject();
            if (GradleUtil.isSnapshot(project) || FileUtil.exists((Project)project, (String)".lfrbuild-releng-ignore")) {
                return;
            }
            File releasePortalRootDir = GradleUtil.getProperty((Project)project, (String)"release.versions.test.other.dir", (File)null);
            if (releasePortalRootDir == null) {
                throw new GradleException("Please set the property \"release.versions.test.other.dir\".");
            }
            File portalRootDir = GradleUtil.getRootDir(project.getRootProject(), "portal-impl");
            if (portalRootDir == null) {
                return;
            }
            String relativePath = FileUtil.relativize((File)project.getProjectDir(), (File)portalRootDir);
            File releaseProjectDir = new File(releasePortalRootDir, relativePath);
            if (!releaseProjectDir.exists()) {
                return;
            }
            File relengDir = LiferayRelengPlugin.getRelengDir(project);
            File releaseRelengDir = LiferayRelengPlugin.getRelengDir(releaseProjectDir);
            if (relengDir == null && releaseRelengDir.isDirectory()) {
                throw new GradleException("Please run this task from " + releaseProjectDir + " instead");
            }
        }
    };

    protected void configureDefaults(Project project, MavenPlugin mavenPlugin) {
        this._configureTaskUploadArchives(project);
    }

    protected Class<MavenPlugin> getPluginClass() {
        return MavenPlugin.class;
    }

    private MavenDefaultsPlugin() {
    }

    private void _configureTaskUploadArchives(Project project) {
        Task uploadArchivesTask = GradleUtil.getTask((Project)project, (String)"uploadArchives");
        uploadArchivesTask.doFirst(failReleaseOnWrongBranchAction);
    }
}

