/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.util.GUtil;

public class GradleUtil
extends com.liferay.gradle.util.GradleUtil {
    public static final String PORTAL_TOOL_GROUP = "com.liferay";
    public static final String SNAPSHOT_PROPERTY_NAME = "snapshot";
    public static final String SNAPSHOT_VERSION_SUFFIX = "-SNAPSHOT";

    public static MavenArtifactRepository addMavenArtifactRepository(RepositoryHandler repositoryHandler, final Object url) {
        return repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository mavenArtifactRepository) {
                mavenArtifactRepository.setUrl(url);
            }
        });
    }

    public static <T extends Task> T addTask(Project project, String name, Class<T> clazz, boolean overwrite) {
        HashMap<String, Constable> args = new HashMap<String, Constable>();
        args.put("overwrite", Boolean.valueOf(overwrite));
        args.put("type", clazz);
        return (T)project.task(args, name);
    }

    public static void excludeTasksWithProperty(Project project, String propertyName, boolean defaultValue, String ... taskNames) {
        if (!project.hasProperty(propertyName) || !GradleUtil.getProperty((ExtensionAware)project, (String)propertyName, (boolean)defaultValue)) {
            return;
        }
        for (String taskName : taskNames) {
            Task task = GradleUtil.getTask((Project)project, (String)taskName);
            task.setDependsOn(Collections.emptySet());
            task.setEnabled(false);
            task.setFinalizedBy(Collections.emptySet());
        }
    }

    public static String getArchivesBaseName(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        return basePluginConvention.getArchivesBaseName();
    }

    public static String getGradlePropertiesValue(Project project, String key, String defaultValue) {
        File dir = GradleUtil.getRootDir(project, "gradle.properties");
        if (dir == null) {
            return defaultValue;
        }
        Properties properties = GUtil.loadProperties((File)new File(dir, "gradle.properties"));
        return properties.getProperty(key, defaultValue);
    }

    public static File getMavenLocalDir(Project project) {
        RepositoryHandler repositoryHandler = project.getRepositories();
        ArtifactRepository artifactRepository = (ArtifactRepository)repositoryHandler.findByName("MavenLocal");
        if (!(artifactRepository instanceof MavenArtifactRepository)) {
            return null;
        }
        MavenArtifactRepository mavenArtifactRepository = (MavenArtifactRepository)artifactRepository;
        return new File(mavenArtifactRepository.getUrl());
    }

    public static File getMavenLocalFile(Project project, String group, String name, String version) {
        File dir = GradleUtil.getMavenLocalDir(project);
        if (dir == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(group.replace('.', File.separatorChar));
        sb.append(File.separatorChar);
        sb.append(name);
        sb.append(File.separatorChar);
        sb.append(version);
        sb.append(File.separatorChar);
        sb.append(name);
        sb.append('-');
        sb.append(version);
        sb.append(".jar");
        return new File(dir, sb.toString());
    }

    public static Project getProject(Project rootProject, String name) {
        for (Project project : rootProject.getAllprojects()) {
            Set subprojects;
            if (!name.equals(project.getName()) || !(subprojects = project.getSubprojects()).isEmpty()) continue;
            return project;
        }
        return null;
    }

    public static Object getProperty(Object object, String name) {
        try {
            Class<?> clazz = object.getClass();
            Method hasPropertyMethod = clazz.getMethod("hasProperty", String.class);
            boolean hasProperty = (Boolean)hasPropertyMethod.invoke(object, name);
            if (!hasProperty) {
                return null;
            }
            Method getPropertyMethod = clazz.getMethod("getProperty", String.class);
            Object value = getPropertyMethod.invoke(object, name);
            if (value instanceof String && Validator.isNull((String)((String)value))) {
                value = null;
            }
            return value;
        }
        catch (ReflectiveOperationException roe) {
            throw new GradleException("Unable to get property", (Throwable)roe);
        }
    }

    public static String getProperty(Object object, String name, String defaultValue) {
        Object value = GradleUtil.getProperty(object, name);
        if (value == null) {
            return defaultValue;
        }
        return GradleUtil.toString((Object)value);
    }

    public static File getRootDir(File dir, String markerFileName) {
        do {
            File markerFile;
            if (!(markerFile = new File(dir, markerFileName)).exists()) continue;
            return dir;
        } while ((dir = dir.getParentFile()) != null);
        return null;
    }

    public static File getRootDir(Project project, String markerFileName) {
        return GradleUtil.getRootDir(project.getProjectDir(), markerFileName);
    }

    public static File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    public static boolean hasPlugin(Project project, Class<? extends Plugin<?>> pluginClass) {
        PluginContainer pluginContainer = project.getPlugins();
        return pluginContainer.hasPlugin(pluginClass);
    }

    public static boolean hasStartParameterTask(Project project, String taskName) {
        Gradle gradle = project.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        List taskNames = startParameter.getTaskNames();
        return taskNames.contains(taskName) || taskNames.contains(project.getPath() + ":" + taskName);
    }

    public static boolean isFromMavenLocal(Project project, File file) {
        File mavenLocalDir = GradleUtil.getMavenLocalDir(project);
        return mavenLocalDir != null && FileUtil.isChild((File)file, (File)mavenLocalDir);
    }

    public static boolean isSnapshot(Project project) {
        String version = String.valueOf(project.getVersion());
        return version.endsWith(SNAPSHOT_VERSION_SUFFIX);
    }

    public static boolean isSnapshot(Project project, String ... propertyNames) {
        boolean snapshot = false;
        if (project.hasProperty(SNAPSHOT_PROPERTY_NAME)) {
            snapshot = GradleUtil.getProperty((ExtensionAware)project, (String)SNAPSHOT_PROPERTY_NAME, (boolean)true);
        }
        if (!snapshot) {
            for (String propertyName : propertyNames) {
                if (!project.hasProperty(propertyName) || !GradleUtil.getProperty((ExtensionAware)project, (String)propertyName, (boolean)true)) continue;
                snapshot = true;
                break;
            }
        }
        return snapshot;
    }

    public static boolean isTestProject(Project project) {
        String projectName = project.getName();
        return projectName.endsWith("-test");
    }

    public static void setProjectSnapshotVersion(Project project, String ... propertyNames) {
        String version = String.valueOf(project.getVersion());
        if (GradleUtil.isSnapshot(project, propertyNames) && !version.endsWith(SNAPSHOT_VERSION_SUFFIX)) {
            project.setVersion((Object)(version + SNAPSHOT_VERSION_SUFFIX));
        }
    }

    public static void substituteModuleDependencyWithProject(Configuration configuration, ModuleVersionSelector moduleVersionSelector, Project project) {
        ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
        DependencySubstitutions dependencySubstitutions = resolutionStrategy.getDependencySubstitution();
        ComponentSelector moduleComponentSelector = dependencySubstitutions.module(GradleUtil._getDependencyNotation(moduleVersionSelector));
        DependencySubstitutions.Substitution substitution = dependencySubstitutions.substitute(moduleComponentSelector);
        ComponentSelector projectComponentSelector = dependencySubstitutions.project(project.getPath());
        substitution.with(projectComponentSelector);
    }

    public static <P extends Plugin<? extends Project>> void withPlugin(Project project, Class<P> pluginClass, Action<P> action) {
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(pluginClass, action);
    }

    private static String _getDependencyNotation(ModuleVersionSelector moduleVersionSelector) {
        StringBuilder sb = new StringBuilder();
        sb.append(moduleVersionSelector.getGroup());
        sb.append(':');
        sb.append(moduleVersionSelector.getName());
        sb.append(':');
        sb.append(moduleVersionSelector.getVersion());
        return sb.toString();
    }
}

