/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.tasks;

import aQute.service.reporter.Reporter;
import com.liferay.ant.bnd.Baseline;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;

public class BaselineTask
extends DefaultTask
implements VerificationTask {
    private Object _bndFile;
    private boolean _ignoreFailures;
    private String _logFileName = "baseline/" + this.getName() + ".log";
    private Object _newJarFile;
    private Object _oldJarFile;
    private boolean _reportDiff;
    private boolean _reportOnlyDirtyPackages;
    private Object _sourceDir;

    @TaskAction
    public void baseline() throws Exception {
        final Logger logger = this.getLogger();
        Baseline baseline = new Baseline(){

            protected void log(Reporter reporter) {
                if (logger.isErrorEnabled()) {
                    for (String message : reporter.getErrors()) {
                        logger.error(message);
                    }
                }
                if (logger.isWarnEnabled()) {
                    for (String message : reporter.getWarnings()) {
                        logger.warn(message);
                    }
                }
            }

            protected void log(String output) {
                if (logger.isLifecycleEnabled()) {
                    logger.lifecycle(output);
                }
            }
        };
        baseline.setBndFile(this.getBndFile());
        baseline.setForcePackageInfo(true);
        baseline.setLogFile(this.getLogFile());
        baseline.setNewJarFile(this.getNewJarFile());
        baseline.setOldJarFile(this.getOldJarFile());
        baseline.setReportDiff(this.isReportDiff());
        baseline.setReportOnlyDirtyPackages(this.isReportOnlyDirtyPackages());
        baseline.setSourceDir(this.getSourceDir());
        boolean match = baseline.execute();
        if (!match) {
            String message = "Semantic versioning is incorrect";
            if (this.getIgnoreFailures()) {
                if (logger.isWarnEnabled()) {
                    logger.warn(message);
                }
            } else {
                throw new GradleException(message);
            }
        }
    }

    @Input
    @Optional
    public File getBndFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._bndFile);
    }

    public boolean getIgnoreFailures() {
        return this._ignoreFailures;
    }

    @Input
    @Optional
    public File getLogFile() {
        if (Validator.isNull((String)this._logFileName)) {
            return null;
        }
        ReportingExtension reportingExtension = (ReportingExtension)GradleUtil.getExtension((ExtensionAware)this.getProject(), ReportingExtension.class);
        return reportingExtension.file(this._logFileName);
    }

    @InputFile
    public File getNewJarFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._newJarFile);
    }

    @InputFile
    public File getOldJarFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._oldJarFile);
    }

    @Input
    @Optional
    public File getSourceDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sourceDir);
    }

    @Input
    public boolean isReportDiff() {
        return this._reportDiff;
    }

    @Input
    public boolean isReportOnlyDirtyPackages() {
        return this._reportOnlyDirtyPackages;
    }

    public void setBndFile(Object bndFile) {
        this._bndFile = bndFile;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this._ignoreFailures = ignoreFailures;
    }

    public void setLogFileName(String logFileName) {
        this._logFileName = logFileName;
    }

    public void setNewJarFile(Object newJarFile) {
        this._newJarFile = newJarFile;
    }

    public void setOldJarFile(Object oldJarFile) {
        this._oldJarFile = oldJarFile;
    }

    public void setReportDiff(boolean reportDiff) {
        this._reportDiff = reportDiff;
    }

    public void setReportOnlyDirtyPackages(boolean reportOnlyDirtyPackages) {
        this._reportOnlyDirtyPackages = reportOnlyDirtyPackages;
    }

    public void setSourceDir(Object sourceDir) {
        this._sourceDir = sourceDir;
    }
}

