/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.liferay.gradle.util.OSDetector;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecSpec;

public class GitUtil {
    public static void commit(Project project, String message, boolean quiet) {
        final String messageArg = "--message=\"" + message + "\"";
        if (quiet) {
            project.exec((Action)new Action<ExecSpec>(){

                public void execute(ExecSpec execSpec) {
                    if (OSDetector.isWindows()) {
                        execSpec.setExecutable((Object)"cmd");
                        execSpec.args(new Object[]{"/c"});
                    } else {
                        execSpec.setExecutable((Object)"sh");
                        execSpec.args(new Object[]{"-c"});
                    }
                    execSpec.args(new Object[]{"(git diff-index --cached --quiet HEAD || git commit " + messageArg + ")"});
                }
            });
        } else {
            GitUtil.executeGit(project, "commit", messageArg);
        }
    }

    public static void executeGit(Project project, final Object ... args) {
        project.exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                execSpec.args(args);
                execSpec.setExecutable((Object)"git");
            }
        });
    }

    public static String getGitResult(Project project, final Object ... args) {
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        project.exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                execSpec.args(args);
                execSpec.setExecutable((Object)"git");
                execSpec.setStandardOutput((OutputStream)byteArrayOutputStream);
            }
        });
        String result = byteArrayOutputStream.toString();
        return result.trim();
    }
}

