/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.css.builder;

import com.liferay.gradle.plugins.css.builder.BuildCSSTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.War;
import org.gradle.language.jvm.tasks.ProcessResources;

public class CSSBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_CSS_TASK_NAME = "buildCSS";
    public static final String COPY_CSS_TASK_NAME = "copyCSS";
    public static final String CSS_BUILDER_CONFIGURATION_NAME = "cssBuilder";
    public static final String PORTAL_COMMON_CSS_CONFIGURATION_NAME = "portalCommonCSS";

    public void apply(Project project) {
        Configuration cssBuilderConfiguration = this._addConfigurationCSSBuilder(project);
        Configuration portalCommonCSSConfiguration = this._addConfigurationPortalCommonCSS(project);
        final Sync copyCSSTask = this._addTaskCopyCSS(project);
        final BuildCSSTask buildCSSTask = this._addTaskBuildCSS(project, copyCSSTask);
        this._configureTasksBuildCSS(project, cssBuilderConfiguration, portalCommonCSSConfiguration);
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaLibraryPlugin.class, (Action)new Action<JavaLibraryPlugin>(){

            public void execute(JavaLibraryPlugin javaLibraryPlugin) {
                CSSBuilderPlugin.this._configureTaskProcessResourcesForJavaLibraryPlugin(buildCSSTask, copyCSSTask);
            }
        });
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                CSSBuilderPlugin.this._configureTaskWarForWarPlugin(buildCSSTask, copyCSSTask);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                CSSBuilderPlugin.this._configureTaskBuildCSSJvmArgs(buildCSSTask);
            }
        });
    }

    private Configuration _addConfigurationCSSBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CSS_BUILDER_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                CSSBuilderPlugin.this._addDependenciesCSSBuilder(project);
            }
        });
        configuration.setDescription("Configures Liferay CSS Builder for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private Configuration _addConfigurationPortalCommonCSS(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)PORTAL_COMMON_CSS_CONFIGURATION_NAME);
        configuration.setDescription("Configures com.liferay.frontend.css.common for compiling CSS files.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                CSSBuilderPlugin.this._addDependenciesPortalCommonCSS(project);
            }
        });
        return configuration;
    }

    private void _addDependenciesCSSBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CSS_BUILDER_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.css.builder", (String)"latest.release");
    }

    private void _addDependenciesPortalCommonCSS(Project project) {
        GradleUtil.addDependency((Project)project, (String)PORTAL_COMMON_CSS_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.frontend.css.common", (String)"latest.release", (boolean)false);
        GradleUtil.addDependency((Project)project, (String)PORTAL_COMMON_CSS_CONFIGURATION_NAME, (String)"org.webjars", (String)"font-awesome", (String)"latest.release", (boolean)false);
    }

    private BuildCSSTask _addTaskBuildCSS(Project project, final Sync copyCSSTask) {
        BuildCSSTask buildCSSTask = (BuildCSSTask)GradleUtil.addTask((Project)project, (String)BUILD_CSS_TASK_NAME, BuildCSSTask.class);
        buildCSSTask.dependsOn(new Object[]{copyCSSTask});
        buildCSSTask.setBaseDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return copyCSSTask.getDestinationDir();
            }
        });
        buildCSSTask.setDescription("Build CSS files.");
        buildCSSTask.setGroup("build");
        TaskOutputsInternal taskOutputs = buildCSSTask.getOutputs();
        taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
        return buildCSSTask;
    }

    private Sync _addTaskCopyCSS(Project project) {
        final Sync copyCSSTask = (Sync)GradleUtil.addTask((Project)project, (String)COPY_CSS_TASK_NAME, Sync.class);
        copyCSSTask.setDescription("Copies CSS files to a temp directory.");
        copyCSSTask.include(new String[]{"**/*.css", "**/*.scss"});
        copyCSSTask.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return copyCSSTask.getTemporaryDir();
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaLibraryPlugin.class, (Action)new Action<JavaLibraryPlugin>(){

            public void execute(JavaLibraryPlugin javaLibraryPlugin) {
                CSSBuilderPlugin.this._configureTaskCopyCSSForJavaLibraryPlugin(copyCSSTask);
            }
        });
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                CSSBuilderPlugin.this._configureTaskCopyCSSForWarPlugin(copyCSSTask);
            }
        });
        return copyCSSTask;
    }

    private void _configureTaskBuildCSSClasspath(BuildCSSTask buildCSSTask, FileCollection classpath) {
        buildCSSTask.setClasspath(classpath);
    }

    private void _configureTaskBuildCSSImportFile(BuildCSSTask buildCSSTask, final Configuration portalCommonCSSConfiguration) {
        buildCSSTask.setImports(new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                return portalCommonCSSConfiguration;
            }
        });
    }

    private void _configureTaskBuildCSSJvmArgs(BuildCSSTask buildCSSTask) {
        if (Objects.equals(buildCSSTask.getSassCompilerClassName(), "ruby")) {
            buildCSSTask.jvmArgs(new Object[]{"-Xss4096k"});
        }
    }

    private void _configureTaskCopyCSSForJavaLibraryPlugin(final Sync copyCSSTask) {
        copyCSSTask.from(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = CSSBuilderPlugin.this._getResourcesDir(copyCSSTask.getProject());
                if (!dir.exists()) {
                    return null;
                }
                return dir;
            }
        }});
    }

    private void _configureTaskCopyCSSForWarPlugin(final Sync copyCSSTask) {
        copyCSSTask.from(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = CSSBuilderPlugin.this._getWebAppDir(copyCSSTask.getProject());
                if (!dir.exists()) {
                    return null;
                }
                return dir;
            }
        }});
    }

    private void _configureTaskProcessResourcesForJavaLibraryPlugin(BuildCSSTask buildCSSTask, final Sync copyCSSTask) {
        final Project project = buildCSSTask.getProject();
        ProcessResources processResourcesTask = (ProcessResources)GradleUtil.getTask((Project)project, (String)"processResources");
        processResourcesTask.dependsOn(new Object[]{buildCSSTask});
        processResourcesTask.setDuplicatesStrategy(DuplicatesStrategy.INCLUDE);
        processResourcesTask.from(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                File resourcesDir = CSSBuilderPlugin.this._getResourcesDir(project);
                if (!resourcesDir.exists()) {
                    return null;
                }
                return copyCSSTask.getDestinationDir();
            }
        }});
    }

    private void _configureTasksBuildCSS(Project project, final Configuration cssBuilderConfiguration, final Configuration portalCommonCSSConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildCSSTask.class, (Action)new Action<BuildCSSTask>(){

            public void execute(BuildCSSTask buildCSSTask) {
                CSSBuilderPlugin.this._configureTaskBuildCSSClasspath(buildCSSTask, (FileCollection)cssBuilderConfiguration);
                CSSBuilderPlugin.this._configureTaskBuildCSSImportFile(buildCSSTask, portalCommonCSSConfiguration);
            }
        });
    }

    private void _configureTaskWarForWarPlugin(final BuildCSSTask buildCSSTask, final Sync copyCSSTask) {
        War war = (War)GradleUtil.getTask((Project)buildCSSTask.getProject(), (String)"war");
        war.dependsOn(new Object[]{buildCSSTask});
        war.eachFile((Action)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                String outputDirName = this._normalizeDirName(buildCSSTask.getOutputDirName());
                String path = fileCopyDetails.getPath();
                fileCopyDetails.setPath(path.replace('/' + outputDirName + '/', "/"));
            }

            private String _normalizeDirName(String dirName) {
                String name = dirName.replace('\\', '/');
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (name.charAt(name.length() - 1) == '/') {
                    name = name.substring(0, name.length() - 1);
                }
                return name;
            }
        });
        war.exclude(new String[]{"**/*.scss"});
        war.from(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                return copyCSSTask.getDestinationDir();
            }
        }});
        war.setDuplicatesStrategy(DuplicatesStrategy.INCLUDE);
        war.setIncludeEmptyDirs(false);
    }

    private File _getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this._getSrcDir(sourceSet.getResources());
    }

    private File _getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }

    private File _getWebAppDir(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        return warPluginConvention.getWebAppDir();
    }
}

