/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.change.log.builder.util;

import com.liferay.gradle.util.Validator;
import java.util.Comparator;

public class NaturalOrderStringComparator
implements Comparator<String> {
    private final boolean _ascending;
    private final boolean _caseSensitive;

    public NaturalOrderStringComparator() {
        this(true, false);
    }

    public NaturalOrderStringComparator(boolean ascending, boolean caseSensitive) {
        this._ascending = ascending;
        this._caseSensitive = caseSensitive;
    }

    @Override
    public int compare(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        int value = 0;
        int i1 = 0;
        int i2 = 0;
        int length1 = s1.length();
        int length2 = s2.length();
        while (i1 < length1 && i2 < length2) {
            char c2UpperCase;
            char c1 = s1.charAt(i1);
            char c2 = s2.charAt(i2);
            if (Character.isDigit(c1) && Character.isDigit(c2)) {
                int leadingNumber2;
                String leadingDigitsAsString1 = this._extractLeadingDigits(s1.substring(i1));
                String leadingDigitsAsString2 = this._extractLeadingDigits(s2.substring(i2));
                int leadingNumber1 = Integer.parseInt(leadingDigitsAsString1);
                if (leadingNumber1 != (leadingNumber2 = Integer.parseInt(leadingDigitsAsString2))) {
                    value = leadingNumber1 - leadingNumber2;
                    break;
                }
                i1 += leadingDigitsAsString1.length();
                i2 += leadingDigitsAsString2.length();
                continue;
            }
            if (c1 == c2) {
                ++i1;
                ++i2;
                continue;
            }
            if (this._caseSensitive) {
                value = c1 - c2;
                break;
            }
            char c1UpperCase = Character.toUpperCase(c1);
            if (c1UpperCase == (c2UpperCase = Character.toUpperCase(c2))) {
                ++i1;
                ++i2;
                continue;
            }
            value = c1UpperCase - c2UpperCase;
            break;
        }
        if (value == 0 && length1 != length2) {
            value = length1 == i1 && length2 == i2 ? length2 - length1 : length1 - length2;
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    private String _extractLeadingDigits(String s) {
        char[] chars;
        if (Validator.isNull((String)s)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : chars = s.toCharArray()) {
            if (!Character.isDigit(c)) {
                return sb.toString();
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

