/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.change.log.builder.util;

import com.liferay.gradle.util.FileUtil;
import java.io.File;
import java.util.Date;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.util.FS;
import org.gradle.api.GradleException;

public class GitUtil {
    public static Iterable<RevCommit> getCommits(Iterable<File> dirs, String rangeStart, String rangeEnd, Repository repository) throws Exception {
        try (Git git = Git.wrap((Repository)repository);){
            LogCommand logCommand = git.log();
            for (File dir : dirs) {
                logCommand.addPath(GitUtil._relativize(dir, repository));
            }
            logCommand.addRange((AnyObjectId)repository.resolve(rangeStart), (AnyObjectId)repository.resolve(rangeEnd));
            Iterable iterable = logCommand.call();
            return iterable;
        }
    }

    public static String getHashBefore(Date date, Repository repository) throws Exception {
        try (RevWalk revWalk = new RevWalk(repository);){
            revWalk.markStart(revWalk.parseCommit((AnyObjectId)repository.resolve("HEAD")));
            revWalk.setRetainBody(false);
            revWalk.setRevFilter(AndRevFilter.create((RevFilter)CommitTimeRevFilter.before((Date)date), (RevFilter)MaxCountRevFilter.create((int)1)));
            RevCommit revCommit = revWalk.next();
            if (revCommit == null) {
                throw new GradleException("Unable to find any commit before " + date);
            }
            String string = revCommit.name();
            return string;
        }
    }

    public static String getHashHead(Repository repository) throws Exception {
        ObjectId objectId = repository.resolve("HEAD");
        return objectId.name();
    }

    public static Repository openRepository(File gitDir) throws Exception {
        gitDir = GitUtil._getGitDir(gitDir);
        return RepositoryCache.open((RepositoryCache.Key)RepositoryCache.FileKey.exact((File)gitDir, (FS)FS.DETECTED));
    }

    private static File _getGitDir(File dir) {
        do {
            File gitDir;
            if ((gitDir = RepositoryCache.FileKey.resolve((File)dir, (FS)FS.DETECTED)) == null) continue;
            return gitDir;
        } while ((dir = dir.getParentFile()) != null);
        throw new GradleException("Unable to locate .git directory");
    }

    private static String _relativize(File file, Repository repository) {
        File gitDir = repository.getDirectory();
        String relativePath = FileUtil.relativize((File)file, (File)gitDir.getParentFile());
        if (File.separatorChar == '\\') {
            relativePath = relativePath.replace('\\', '/');
        }
        return relativePath;
    }
}

