/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.change.log.builder;

import com.liferay.gradle.plugins.change.log.builder.util.GitUtil;
import com.liferay.gradle.plugins.change.log.builder.util.NaturalOrderStringComparator;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GUtil;

public class BuildChangeLogTask
extends DefaultTask {
    private static final Pattern _lastRangeEndPattern = Pattern.compile("\\.\\.([0-9a-f]{40})=.*$");
    private Object _changeLogFile;
    private Object _changeLogHeader;
    private final Set<Object> _dirs = new HashSet<Object>();
    private Object _gitDir;
    private Object _rangeEnd;
    private Object _rangeStart;
    private final Set<String> _ticketIdPrefixes = new HashSet<String>();

    public BuildChangeLogTask() {
        Project project = this.getProject();
        this.setGitDir(project.getRootDir());
        this.setTicketIdPrefixes("CLDSVCS", "LPS", "SOS", "SYNC");
    }

    @TaskAction
    public void buildChangeLog() throws Exception {
        Set<String> ticketIds;
        Project project = this.getProject();
        File changeLogFile = this.getChangeLogFile();
        Path changeLogPath = changeLogFile.toPath();
        String changeLogContent = null;
        if (changeLogFile.exists()) {
            changeLogContent = new String(Files.readAllBytes(changeLogPath), StandardCharsets.UTF_8);
        }
        String rangeEnd = this.getRangeEnd();
        String rangeStart = this.getRangeStart();
        try (Repository repository = GitUtil.openRepository(this.getGitDir());){
            if (Validator.isNull((String)rangeEnd)) {
                rangeEnd = GitUtil.getHashHead(repository);
            }
            if (Validator.isNull((String)rangeStart)) {
                rangeStart = this.getRangeStart(changeLogContent, repository);
            }
            ticketIds = this.getTicketIds(rangeStart, rangeEnd, repository);
        }
        String range = rangeStart + ".." + rangeEnd;
        if (ticketIds.isEmpty()) {
            throw new StopExecutionException(project + " does not have changes for range " + range);
        }
        File changeLogDir = changeLogFile.getParentFile();
        changeLogDir.mkdirs();
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(changeLogPath, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
            if (Validator.isNotNull((String)changeLogContent)) {
                bufferedWriter.newLine();
                bufferedWriter.newLine();
            }
            bufferedWriter.append('#');
            bufferedWriter.newLine();
            bufferedWriter.append("# ");
            bufferedWriter.append(this.getChangeLogHeader());
            bufferedWriter.newLine();
            bufferedWriter.append('#');
            bufferedWriter.newLine();
            bufferedWriter.append(range);
            bufferedWriter.append('=');
            boolean firstTicket = true;
            for (String ticketId : ticketIds) {
                if (firstTicket) {
                    firstTicket = false;
                } else {
                    bufferedWriter.append(' ');
                }
                bufferedWriter.append(ticketId);
            }
        }
    }

    public BuildChangeLogTask dirs(Iterable<?> dirs) {
        GUtil.addToCollection(this._dirs, (Iterable[])new Iterable[]{dirs});
        return this;
    }

    public BuildChangeLogTask dirs(Object ... dirs) {
        return this.dirs(Arrays.asList(dirs));
    }

    @Input
    public File getChangeLogFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._changeLogFile);
    }

    @Input
    public String getChangeLogHeader() {
        return GradleUtil.toString((Object)this._changeLogHeader);
    }

    @Input
    public Iterable<File> getDirs() {
        Project project = this.getProject();
        return project.files(new Object[]{this._dirs});
    }

    @Input
    public File getGitDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._gitDir);
    }

    @Input
    @Optional
    public String getRangeEnd() {
        return GradleUtil.toString((Object)this._rangeEnd);
    }

    @Input
    @Optional
    public String getRangeStart() {
        return GradleUtil.toString((Object)this._rangeStart);
    }

    @Input
    public Set<String> getTicketIdPrefixes() {
        return this._ticketIdPrefixes;
    }

    public void setChangeLogFile(Object changeLogFile) {
        this._changeLogFile = changeLogFile;
    }

    public void setChangeLogHeader(Object changeLogHeader) {
        this._changeLogHeader = changeLogHeader;
    }

    public void setDirs(Iterable<?> dirs) {
        this._dirs.clear();
        this.dirs(dirs);
    }

    public void setDirs(Object ... dirs) {
        this.setDirs(Arrays.asList(dirs));
    }

    public void setGitDir(Object gitDir) {
        this._gitDir = gitDir;
    }

    public void setRangeEnd(Object rangeEnd) {
        this._rangeEnd = rangeEnd;
    }

    public void setRangeStart(Object rangeStart) {
        this._rangeStart = rangeStart;
    }

    public void setTicketIdPrefixes(Iterable<String> ticketIdPrefixes) {
        this._ticketIdPrefixes.clear();
        this.ticketIdPrefixes(ticketIdPrefixes);
    }

    public void setTicketIdPrefixes(String ... ticketIdPrefixes) {
        this.setTicketIdPrefixes(Arrays.asList(ticketIdPrefixes));
    }

    public BuildChangeLogTask ticketIdPrefixes(Iterable<String> ticketIdPrefixes) {
        GUtil.addToCollection(this._ticketIdPrefixes, (Iterable[])new Iterable[]{ticketIdPrefixes});
        return this;
    }

    public BuildChangeLogTask ticketIdPrefixes(String ... ticketIdPrefixes) {
        return this.ticketIdPrefixes(Arrays.asList(ticketIdPrefixes));
    }

    protected String getRangeStart(String changeLogContent, Repository repository) throws Exception {
        String rangeStart;
        if (Validator.isNotNull((String)changeLogContent)) {
            Matcher matcher = _lastRangeEndPattern.matcher(changeLogContent);
            if (!matcher.find()) {
                throw new GradleException("Unable to find the range start");
            }
            rangeStart = matcher.group(1);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, -2);
            rangeStart = GitUtil.getHashBefore(calendar.getTime(), repository);
        }
        return rangeStart + "^";
    }

    protected Set<String> getTicketIds(String rangeStart, String rangeEnd, Repository repository) throws Exception {
        TreeSet<String> ticketIds = new TreeSet<String>(new NaturalOrderStringComparator());
        Set<String> ticketIdPrefixes = this.getTicketIdPrefixes();
        Iterable<RevCommit> revCommits = GitUtil.getCommits(this.getDirs(), rangeStart, rangeEnd, repository);
        for (RevCommit revCommit : revCommits) {
            String prefix;
            String message = revCommit.getShortMessage();
            int index = message.indexOf(45);
            if (index == -1 || !ticketIdPrefixes.contains(prefix = message.substring(0, index))) continue;
            index = message.indexOf(32);
            if (index == -1) {
                index = message.length();
            }
            ticketIds.add(message.substring(0, index));
        }
        return ticketIds;
    }
}

