/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.change.log.builder;

import com.liferay.gradle.plugins.change.log.builder.util.GitUtil;
import com.liferay.gradle.plugins.change.log.builder.util.NaturalOrderStringComparator;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GUtil;

public class BuildChangeLogTask
extends DefaultTask {
    private static final Pattern _lastRangeEndPattern = Pattern.compile("\\.\\.([0-9a-f]{40})=.*$");
    private Object _changeLogFile;
    private Object _changeLogHeader;
    private final Set<String> _ticketIdPrefixes = new HashSet<String>();

    public BuildChangeLogTask() {
        this.setChangeLogHeader(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Project project = BuildChangeLogTask.this.getProject();
                return "Bundle Version " + project.getVersion();
            }
        });
        this.setTicketIdPrefixes("CLDSVCS", "LPS", "SOS", "SYNC");
    }

    @TaskAction
    public void buildChangeLog() throws Exception {
        Set<String> ticketIds;
        String range;
        Project project = this.getProject();
        File changeLogFile = this.getChangeLogFile();
        Path changeLogPath = changeLogFile.toPath();
        String changeLogContent = null;
        if (changeLogFile.exists()) {
            changeLogContent = new String(Files.readAllBytes(changeLogPath), StandardCharsets.UTF_8);
        }
        try (Repository repository = GitUtil.openRepository(project);){
            String rangeEnd = GitUtil.getHashHead(repository);
            String rangeStart = this.getRangeStart(changeLogContent, repository);
            range = rangeStart + ".." + rangeEnd;
            ticketIds = this.getTicketIds(rangeStart, rangeEnd, repository);
        }
        if (ticketIds.isEmpty()) {
            throw new StopExecutionException(project + " does not have changes for range " + range);
        }
        File changeLogDir = changeLogFile.getParentFile();
        changeLogDir.mkdirs();
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(changeLogPath, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
            if (Validator.isNotNull((String)changeLogContent)) {
                bufferedWriter.newLine();
                bufferedWriter.newLine();
            }
            bufferedWriter.append('#');
            bufferedWriter.newLine();
            bufferedWriter.append("# ");
            bufferedWriter.append(this.getChangeLogHeader());
            bufferedWriter.newLine();
            bufferedWriter.append('#');
            bufferedWriter.newLine();
            bufferedWriter.append(range);
            bufferedWriter.append('=');
            boolean firstTicket = true;
            for (String ticketId : ticketIds) {
                if (firstTicket) {
                    firstTicket = false;
                } else {
                    bufferedWriter.append(' ');
                }
                bufferedWriter.append(ticketId);
            }
        }
    }

    @Input
    public File getChangeLogFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._changeLogFile);
    }

    @Input
    public String getChangeLogHeader() {
        return GradleUtil.toString((Object)this._changeLogHeader);
    }

    @Input
    public Set<String> getTicketIdPrefixes() {
        return this._ticketIdPrefixes;
    }

    public void setChangeLogFile(Object changeLogFile) {
        this._changeLogFile = changeLogFile;
    }

    public void setChangeLogHeader(Object changeLogHeader) {
        this._changeLogHeader = changeLogHeader;
    }

    public void setTicketIdPrefixes(Iterable<String> ticketIdPrefixes) {
        this._ticketIdPrefixes.clear();
        this.ticketIdPrefixes(ticketIdPrefixes);
    }

    public void setTicketIdPrefixes(String ... ticketIdPrefixes) {
        this.setTicketIdPrefixes(Arrays.asList(ticketIdPrefixes));
    }

    public BuildChangeLogTask ticketIdPrefixes(Iterable<String> ticketIdPrefixes) {
        GUtil.addToCollection(this._ticketIdPrefixes, (Iterable[])new Iterable[]{ticketIdPrefixes});
        return this;
    }

    public BuildChangeLogTask ticketIdPrefixes(String ... ticketIdPrefixes) {
        return this.ticketIdPrefixes(Arrays.asList(ticketIdPrefixes));
    }

    protected String getRangeStart(String changeLogContent, Repository repository) throws Exception {
        String rangeStart;
        if (Validator.isNotNull((String)changeLogContent)) {
            Matcher matcher = _lastRangeEndPattern.matcher(changeLogContent);
            if (!matcher.find()) {
                throw new GradleException("Unable to find the range start");
            }
            rangeStart = matcher.group(1);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.add(1, -1);
            rangeStart = GitUtil.getHashBefore(calendar.getTime(), repository);
        }
        return rangeStart + "^";
    }

    protected Set<String> getTicketIds(String rangeStart, String rangeEnd, Repository repository) throws Exception {
        TreeSet<String> ticketIds = new TreeSet<String>(new NaturalOrderStringComparator());
        Project project = this.getProject();
        Set<String> ticketIdPrefixes = this.getTicketIdPrefixes();
        Iterable<RevCommit> revCommits = GitUtil.getCommits(project.getProjectDir(), rangeStart, rangeEnd, repository);
        for (RevCommit revCommit : revCommits) {
            String prefix;
            String message = revCommit.getShortMessage();
            int index = message.indexOf(45);
            if (index == -1 || !ticketIdPrefixes.contains(prefix = message.substring(0, index))) continue;
            index = message.indexOf(32);
            if (index == -1) {
                index = message.length();
            }
            ticketIds.add(message.substring(0, index));
        }
        return ticketIds;
    }
}

