/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.cache.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;

public class FileUtil
extends com.liferay.gradle.util.FileUtil {
    private static final Logger _logger = Logging.getLogger(FileUtil.class);

    public static Set<File> flattenAndSort(Iterable<File> files, File rootDir) throws IOException {
        final TreeSet<File> sortedFiles = new TreeSet<File>(new FileComparator(rootDir));
        for (File file : files) {
            if (file.isDirectory()) {
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        sortedFiles.add(path.toFile());
                        return FileVisitResult.CONTINUE;
                    }
                });
                continue;
            }
            sortedFiles.add(file);
        }
        return sortedFiles;
    }

    public static String getDigest(File file) {
        String digest;
        try {
            List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
            digest = Integer.toHexString(lines.hashCode());
        }
        catch (IOException ioe) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(file + " is not a text file", (Throwable)ioe);
            }
            HashValue hashValue = HashUtil.sha1((File)file);
            digest = hashValue.asHexString();
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Digest of " + file + " is " + digest);
        }
        return digest;
    }

    private static class FileComparator
    implements Comparator<File> {
        private final File _rootDir;

        public FileComparator(File rootDir) {
            this._rootDir = rootDir;
        }

        @Override
        public int compare(File file1, File file2) {
            String relativePath1 = this._getRelativePath(file1);
            String relativePath2 = this._getRelativePath(file2);
            return relativePath1.compareTo(relativePath2);
        }

        private String _getRelativePath(File file) {
            String relativePath = com.liferay.gradle.util.FileUtil.relativize((File)file, (File)this._rootDir);
            if (File.separatorChar != '/') {
                relativePath = relativePath.replace(File.separatorChar, '/');
            }
            return relativePath;
        }
    }
}

