/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.cache.task;

import com.liferay.gradle.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GUtil;

public class TaskCache
implements PatternFilterable {
    private Object _baseDir;
    private Object _cacheDir;
    private final String _name;
    private final PatternFilterable _patternFilterable = new PatternSet();
    private final Project _project;
    private final Set<Object> _skippedTaskDependencies = new LinkedHashSet<Object>();
    private final List<Object> _testFiles = new ArrayList<Object>();

    public TaskCache(String name, Project project) {
        this._baseDir = project.getProjectDir();
        this._cacheDir = project.file((Object)(".cache/" + name));
        this._name = name;
        this._project = project;
    }

    public TaskCache exclude(Closure excludeSpec) {
        this._patternFilterable.exclude(excludeSpec);
        return this;
    }

    public TaskCache exclude(Iterable<String> excludes) {
        this._patternFilterable.exclude(excludes);
        return this;
    }

    public TaskCache exclude(Spec<FileTreeElement> excludeSpec) {
        this._patternFilterable.exclude(excludeSpec);
        return this;
    }

    public TaskCache exclude(String ... excludes) {
        this._patternFilterable.exclude(excludes);
        return this;
    }

    public File getBaseDir() {
        return GradleUtil.toFile((Project)this._project, (Object)this._baseDir);
    }

    public File getCacheDir() {
        return GradleUtil.toFile((Project)this._project, (Object)this._cacheDir);
    }

    public Set<String> getExcludes() {
        return this._patternFilterable.getExcludes();
    }

    public FileTree getFiles() {
        ConfigurableFileTree fileTree = this._project.fileTree((Object)this.getBaseDir());
        return fileTree.matching(this._patternFilterable);
    }

    public Set<String> getIncludes() {
        return this._patternFilterable.getIncludes();
    }

    public String getName() {
        return this._name;
    }

    public Project getProject() {
        return this._project;
    }

    public Set<Object> getSkippedTaskDependencies() {
        return this._skippedTaskDependencies;
    }

    public Task getTask() {
        return GradleUtil.getTask((Project)this._project, (String)this._name);
    }

    public FileCollection getTestFiles() {
        return this._project.files(new Object[]{this._testFiles});
    }

    public TaskCache include(Closure includeSpec) {
        this._patternFilterable.include(includeSpec);
        return this;
    }

    public TaskCache include(Iterable<String> includes) {
        this._patternFilterable.include(includes);
        return this;
    }

    public TaskCache include(Spec<FileTreeElement> includeSpec) {
        this._patternFilterable.include(includeSpec);
        return this;
    }

    public TaskCache include(String ... includes) {
        this._patternFilterable.include(includes);
        return this;
    }

    public void setBaseDir(Object baseDir) {
        this._baseDir = baseDir;
    }

    public void setCacheDir(Object cacheDir) {
        this._cacheDir = cacheDir;
    }

    public TaskCache setExcludes(Iterable<String> excludes) {
        this._patternFilterable.setExcludes(excludes);
        return this;
    }

    public TaskCache setIncludes(Iterable<String> includes) {
        this._patternFilterable.setIncludes(includes);
        return this;
    }

    public void setSkippedTaskDependencies(Iterable<Object> skippedTaskDependencies) {
        this._skippedTaskDependencies.clear();
        this.skipTaskDependency(skippedTaskDependencies);
    }

    public void setSkippedTaskDependencies(Object ... skippedTaskDependencies) {
        this.setSkippedTaskDependencies(Arrays.asList(skippedTaskDependencies));
    }

    public void setTestFiles(Iterable<Object> testFiles) {
        this._testFiles.clear();
        this.testFile(testFiles);
    }

    public void setTestFiles(Object ... testFiles) {
        this.setTestFiles(Arrays.asList(testFiles));
    }

    public TaskCache skipTaskDependency(Iterable<Object> skippedTaskDependencies) {
        GUtil.addToCollection(this._skippedTaskDependencies, (Iterable[])new Iterable[]{skippedTaskDependencies});
        return this;
    }

    public TaskCache skipTaskDependency(Object ... skippedTaskDependencies) {
        return this.skipTaskDependency(Arrays.asList(skippedTaskDependencies));
    }

    public TaskCache testFile(Iterable<Object> testFiles) {
        GUtil.addToCollection(this._testFiles, (Iterable[])new Iterable[]{testFiles});
        return this;
    }

    public TaskCache testFile(Object ... testFiles) {
        return this.testFile(Arrays.asList(testFiles));
    }
}

