/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.cache;

import com.liferay.gradle.plugins.cache.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;

public class WriteDigestTask
extends SourceTask {
    private Object _digestFile = ".digest";
    private boolean _excludeIgnoredFiles = true;

    public String getDigest() {
        return FileUtil.getDigest(this.getProject(), (Iterable<File>)this.getSource(), this.isExcludeIgnoredFiles());
    }

    @OutputFile
    public File getDigestFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._digestFile);
    }

    public String getOldDigest() {
        try {
            File digestFile = this.getDigestFile();
            if (!digestFile.exists()) {
                return null;
            }
            return new String(Files.readAllBytes(digestFile.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    @Input
    public boolean isExcludeIgnoredFiles() {
        return this._excludeIgnoredFiles;
    }

    public void setDigestFile(Object digestFile) {
        this._digestFile = digestFile;
    }

    public void setExcludeIgnoredFiles(boolean excludeIgnoredFiles) {
        this._excludeIgnoredFiles = excludeIgnoredFiles;
    }

    @TaskAction
    public void writeDigest() {
        try {
            Logger logger = this.getLogger();
            String digest = this.getDigest();
            File digestFile = this.getDigestFile();
            Files.write(digestFile.toPath(), digest.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            if (logger.isInfoEnabled()) {
                logger.info("Updated {} to {}", (Object)digestFile, (Object)digest);
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }
}

