/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.cache.util;

import com.liferay.gradle.plugins.cache.util.StringUtil;
import com.liferay.gradle.util.Validator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.process.ExecSpec;
import org.gradle.process.internal.ExecException;

public class FileUtil
extends com.liferay.gradle.util.FileUtil {
    private static final Logger _logger = Logging.getLogger(FileUtil.class);

    public static SortedSet<File> flattenAndSort(Iterable<File> files) throws IOException {
        final TreeSet<File> sortedFiles = new TreeSet<File>(new FileComparator());
        for (File file : files) {
            if (file.isDirectory()) {
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        sortedFiles.add(path.toFile());
                        return FileVisitResult.CONTINUE;
                    }
                });
                continue;
            }
            sortedFiles.add(file);
        }
        return sortedFiles;
    }

    public static String getDigest(File file) {
        String digest;
        try {
            List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
            digest = Integer.toHexString(lines.hashCode());
        }
        catch (IOException ioe) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(file + " is not a text file", (Throwable)ioe);
            }
            HashValue hashValue = HashUtil.sha1((File)file);
            digest = hashValue.asHexString();
        }
        if (_logger.isInfoEnabled()) {
            _logger.info("Digest of " + file + " is " + digest);
        }
        return digest;
    }

    public static boolean removeIgnoredFiles(Project project, SortedSet<File> files) {
        if (files.isEmpty()) {
            return false;
        }
        File rootDir = null;
        File firstFile = files.first();
        if (files.size() == 1) {
            rootDir = firstFile.getParentFile();
        } else {
            String dirName = StringUtil.getCommonPrefix('/', FileUtil._getCanonicalPath(firstFile), FileUtil._getCanonicalPath(files.last()));
            if (Validator.isNotNull((String)dirName)) {
                rootDir = new File(dirName);
            }
        }
        if (rootDir == null) {
            if (_logger.isWarnEnabled()) {
                _logger.warn("Unable to remove ignored files, common parent directory cannot be found");
            }
            return false;
        }
        String result = FileUtil._getGitResult(project, rootDir, "ls-files", "--cached", "--deleted", "--exclude-standard", "--modified", "--others", "-z");
        if (Validator.isNull((String)result)) {
            if (_logger.isWarnEnabled()) {
                _logger.warn("Unable to remove ignored files, Git returned an empty result");
            }
            return false;
        }
        String[] committedFileNames = result.split("\\000");
        HashSet<File> committedFiles = new HashSet<File>();
        for (String fileName : committedFileNames) {
            committedFiles.add(new File(rootDir, fileName));
        }
        return files.retainAll(committedFiles);
    }

    private static String _getCanonicalPath(File file) {
        try {
            String canonicalPath = file.getCanonicalPath();
            if (File.separatorChar != '/') {
                canonicalPath = canonicalPath.replace(File.separatorChar, '/');
            }
            return canonicalPath;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Unable to get canonical path of " + file, (Throwable)ioe);
        }
    }

    private static String _getGitResult(Project project, final File workingDir, final String ... args) {
        ByteArrayOutputStream byteArrayOutputStream;
        block2: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                project.exec((Action)new Action<ExecSpec>(){

                    public void execute(ExecSpec execSpec) {
                        execSpec.setArgs(Arrays.asList(args));
                        execSpec.setExecutable((Object)"git");
                        execSpec.setStandardOutput((OutputStream)byteArrayOutputStream);
                        execSpec.setWorkingDir((Object)workingDir);
                    }
                });
            }
            catch (ExecException ee) {
                if (!_logger.isInfoEnabled()) break block2;
                _logger.info(ee.getMessage(), (Throwable)ee);
            }
        }
        return byteArrayOutputStream.toString();
    }

    private static class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            String canonicalPath1 = FileUtil._getCanonicalPath(file1);
            String canonicalPath2 = FileUtil._getCanonicalPath(file2);
            return canonicalPath1.compareTo(canonicalPath2);
        }
    }
}

