/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.cache.task;

import com.liferay.gradle.plugins.cache.CacheExtension;
import com.liferay.gradle.plugins.cache.task.TaskCache;
import com.liferay.gradle.plugins.cache.util.FileUtil;
import com.liferay.gradle.plugins.cache.util.StringUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Set;
import java.util.SortedSet;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Copy;
import org.gradle.util.Clock;

public class TaskCacheApplicator {
    public static final String DIGEST_FILE_NAME = ".digest";
    private static final char _DIGEST_SEPARATOR = '-';
    private static final Logger _logger = Logging.getLogger(TaskCacheApplicator.class);

    public void apply(CacheExtension cacheExtension, TaskCache taskCache) {
        Task task = taskCache.getTask();
        boolean upToDate = false;
        String currentDigest = this.getCurrentDigest(taskCache);
        if (_logger.isInfoEnabled()) {
            _logger.info("Current digest is " + currentDigest);
        }
        if (cacheExtension.isForcedCache()) {
            File cacheDir = taskCache.getCacheDir();
            if (!cacheDir.exists()) {
                throw new GradleException("Unable to find " + cacheDir);
            }
            upToDate = true;
        } else if (taskCache.isDisabled()) {
            if (_logger.isLifecycleEnabled()) {
                _logger.lifecycle("Cache for " + task + " is disabled");
            }
        } else {
            String cachedDigest = this.getCachedDigest(taskCache);
            if (_logger.isInfoEnabled()) {
                if (Validator.isNull((String)cachedDigest)) {
                    _logger.info("No cached digest has been found");
                } else {
                    _logger.info("Cached digest is " + cachedDigest);
                }
            }
            if (cachedDigest.equals(currentDigest)) {
                upToDate = true;
            }
        }
        if (upToDate) {
            this.applyUpToDate(taskCache, task);
        } else {
            this.applyOutOfDate(taskCache, task, currentDigest);
        }
        this.createRefreshDigestTask(taskCache);
    }

    protected void applyOutOfDate(final TaskCache taskCache, Task task, final String currentDigest) {
        if (_logger.isInfoEnabled()) {
            _logger.info(task + " is out-of-date");
        }
        Copy copy = this.createSaveCacheTask(taskCache);
        copy.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                TaskCacheApplicator.this.writeDigestFile(taskCache, currentDigest);
            }
        });
        task.finalizedBy(new Object[]{copy});
    }

    protected void applyUpToDate(TaskCache taskCache, Task task) {
        if (_logger.isInfoEnabled()) {
            _logger.info(task + " is up-to-date");
        }
        this.removeSkippedTaskDependencies(taskCache, task);
        Copy copy = this.createRestoreCacheTask(taskCache);
        task.dependsOn(new Object[]{copy});
        task.setEnabled(false);
    }

    protected Task createRefreshDigestTask(final TaskCache taskCache) {
        Project project = taskCache.getProject();
        Task task = project.task(taskCache.getRefreshDigestTaskName());
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                String digest = TaskCacheApplicator.this.getCurrentDigest(taskCache);
                TaskCacheApplicator.this.writeDigestFile(taskCache, digest);
            }
        });
        task.setDescription("Refresh the digest for " + taskCache);
        return task;
    }

    protected Copy createRestoreCacheTask(TaskCache taskCache) {
        Project project = taskCache.getProject();
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)taskCache.getRestoreCacheTaskName(), Copy.class);
        copy.exclude(new String[]{DIGEST_FILE_NAME});
        copy.from(new Object[]{taskCache.getCacheDir()});
        copy.into((Object)taskCache.getBaseDir());
        copy.setDescription("Restores the cached output files of " + taskCache.getTask() + ".");
        return copy;
    }

    protected Copy createSaveCacheTask(TaskCache taskCache) {
        String taskName = taskCache.getSaveCacheTaskName();
        Copy copy = (Copy)GradleUtil.addTask((Project)taskCache.getProject(), (String)taskName, Copy.class);
        Task task = taskCache.getTask();
        copy.dependsOn(new Object[]{task, "clean" + StringUtil.capitalize((String)taskName)});
        copy.from(new Object[]{taskCache.getFiles()});
        copy.into((Object)taskCache.getCacheDir());
        copy.setDescription("Caches the output files of " + task + ".");
        return copy;
    }

    protected String getCachedDigest(TaskCache taskCache) {
        try {
            File digestFile = new File(taskCache.getCacheDir(), DIGEST_FILE_NAME);
            if (!digestFile.exists()) {
                return "";
            }
            return new String(Files.readAllBytes(digestFile.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new GradleException("Unable to read digest file", (Throwable)ioe);
        }
    }

    protected String getCurrentDigest(TaskCache taskCache) {
        Clock clock = null;
        if (_logger.isInfoEnabled()) {
            clock = new Clock();
        }
        StringBuilder sb = new StringBuilder();
        SortedSet<File> testFiles = null;
        try {
            testFiles = FileUtil.flattenAndSort((Iterable<File>)taskCache.getTestFiles());
        }
        catch (IOException ioe) {
            throw new GradleException("Unable to flatten test files", (Throwable)ioe);
        }
        if (taskCache.isExcludeIgnoredTestFiles()) {
            FileUtil.removeIgnoredFiles(taskCache.getProject(), testFiles);
        }
        for (File testFile : testFiles) {
            if (!testFile.exists() || ".DS_Store".equals(testFile.getName())) continue;
            sb.append(FileUtil.getDigest(testFile));
            sb.append('-');
        }
        if (sb.length() == 0) {
            throw new GradleException("At least one test file is required");
        }
        sb.setLength(sb.length() - 1);
        if (_logger.isInfoEnabled() && clock != null) {
            _logger.info("Getting the current digest took " + clock.getTimeInMs() + " ms");
        }
        return sb.toString();
    }

    protected void removeSkippedTaskDependencies(TaskCache taskCache, Task task) {
        Set taskDependencies = task.getDependsOn();
        Set<Object> skippedTaskDependencies = taskCache.getSkippedTaskDependencies();
        if (skippedTaskDependencies.isEmpty()) {
            taskDependencies.clear();
            if (_logger.isInfoEnabled()) {
                _logger.info("Removed all dependencies from " + task);
            }
        } else {
            for (Object taskDependency : skippedTaskDependencies) {
                boolean removed = taskDependencies.remove(taskDependency);
                if (!removed && taskDependency instanceof Task) {
                    Task taskDependencyTask = (Task)taskDependency;
                    removed = taskDependencies.remove(taskDependencyTask.getName());
                }
                if (removed) {
                    if (!_logger.isInfoEnabled()) continue;
                    _logger.info("Removed dependency " + taskDependency + " from " + task);
                    continue;
                }
                if (!_logger.isWarnEnabled()) continue;
                _logger.warn("Unable to remove skipped task dependency " + taskDependency);
            }
        }
    }

    protected void writeDigestFile(TaskCache taskCache, String digest) {
        File digestFile = new File(taskCache.getCacheDir(), DIGEST_FILE_NAME);
        try {
            Files.write(digestFile.toPath(), digest.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            if (_logger.isInfoEnabled()) {
                _logger.info("Updated digest file to " + digest);
            }
        }
        catch (IOException ioe) {
            throw new GradleException("Unable to write digest file", (Throwable)ioe);
        }
    }
}

