/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.app.javadoc.builder;

import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.util.GUtil;

public class AppJavadocBuilderExtension {
    private boolean _copyTags = true;
    private boolean _doclintDisabled;
    private Closure<String> _groupNameClosure;
    private boolean _groupPackages = true;
    private AndSpec<Project> _onlyIfSpec = new AndSpec();
    private final Set<Project> _subprojects = new LinkedHashSet<Project>();

    public AppJavadocBuilderExtension(Project project) {
        JavaVersion javaVersion = JavaVersion.current();
        if (javaVersion.isJava8Compatible()) {
            this._doclintDisabled = true;
        }
        this._groupNameClosure = new Closure<String>((Object)project){

            public String doCall(Project subproject) {
                String groupName = subproject.getDescription();
                if (Validator.isNull((String)groupName)) {
                    groupName = subproject.getName();
                }
                return groupName;
            }
        };
        this._subprojects.addAll(project.getSubprojects());
    }

    public Closure<String> getGroupNameClosure() {
        return this._groupNameClosure;
    }

    public Spec<Project> getOnlyIf() {
        return this._onlyIfSpec;
    }

    public Set<Project> getSubprojects() {
        return this._subprojects;
    }

    public boolean isCopyTags() {
        return this._copyTags;
    }

    public boolean isDoclintDisabled() {
        return this._doclintDisabled;
    }

    public boolean isGroupPackages() {
        return this._groupPackages;
    }

    public AppJavadocBuilderExtension onlyIf(Closure<Boolean> onlyIfClosure) {
        this._onlyIfSpec = this._onlyIfSpec.and(onlyIfClosure);
        return this;
    }

    public AppJavadocBuilderExtension onlyIf(Spec<Project> onlyIfSpec) {
        this._onlyIfSpec = this._onlyIfSpec.and(onlyIfSpec);
        return this;
    }

    public void setCopyTags(boolean copyTags) {
        this._copyTags = copyTags;
    }

    public void setDoclintDisabled(boolean doclintDisabled) {
        this._doclintDisabled = doclintDisabled;
    }

    public void setGroupNameClosure(Closure<String> groupNameClosure) {
        this._groupNameClosure = groupNameClosure;
    }

    public void setGroupPackages(boolean groupPackages) {
        this._groupPackages = groupPackages;
    }

    public void setOnlyIf(Closure<Boolean> onlyIfClosure) {
        this._onlyIfSpec = new AndSpec();
        this._onlyIfSpec.and(onlyIfClosure);
    }

    public void setOnlyIf(Spec<Project> onlyIfSpec) {
        this._onlyIfSpec = new AndSpec(new Spec[]{onlyIfSpec});
    }

    public void setSubprojects(Iterable<Project> subprojects) {
        this._subprojects.clear();
        this.subprojects(subprojects);
    }

    public void setSubprojects(Project ... subprojects) {
        this.setSubprojects(Arrays.asList(subprojects));
    }

    public AppJavadocBuilderExtension subprojects(Iterable<Project> subprojects) {
        GUtil.addToCollection(this._subprojects, (Iterable[])new Iterable[]{subprojects});
        return this;
    }

    public AppJavadocBuilderExtension subprojects(Project ... subprojects) {
        return this.subprojects(Arrays.asList(subprojects));
    }
}

