/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gogo.shell.web.internal.portlet;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.TransientValue;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=portlet-gogo-shell", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.render-weight=50", "javax.portlet.display-name=Gogo Shell", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_gogo_shell_web_internal_portlet_GogoShellPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class GogoShellPortlet
extends MVCPortlet {
    private static final InputStream _emptyInputStream = new UnsyncByteArrayInputStream(new byte[0]);
    private static final Pattern _pattern = Pattern.compile(".*(close|disconnect|exit|shutdown).*", 10);
    @Reference
    private CommandProcessor _commandProcessor;
    @Reference
    private Portal _portal;

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.initCommandSession((PortletRequest)renderRequest);
        CommandSession commandSession = (CommandSession)GogoShellPortlet._getSessionAttribute((PortletRequest)renderRequest, "COMMAND_SESSION");
        SessionMessages.add((PortletRequest)renderRequest, (String)"prompt", (Object)commandSession.get("prompt"));
        super.doView(renderRequest, renderResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String command = ParamUtil.getString((PortletRequest)actionRequest, (String)"command");
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.initCommandSession((PortletRequest)actionRequest);
        CommandSession commandSession = (CommandSession)GogoShellPortlet._getSessionAttribute((PortletRequest)actionRequest, "COMMAND_SESSION");
        UnsyncByteArrayOutputStream outputUnsyncByteArrayOutputStream = (UnsyncByteArrayOutputStream)GogoShellPortlet._getSessionAttribute((PortletRequest)actionRequest, "COMMAND_SESSION_OUTPUT_STREAM");
        UnsyncByteArrayOutputStream errorUnsyncByteArrayOutputStream = (UnsyncByteArrayOutputStream)GogoShellPortlet._getSessionAttribute((PortletRequest)actionRequest, "COMMAND_SESSION_ERROR_STREAM");
        PrintStream outputPrintStream = (PrintStream)GogoShellPortlet._getSessionAttribute((PortletRequest)actionRequest, "COMMAND_SESSION_OUTPUT_PRINT_STREAM");
        PrintStream errorPrintStream = (PrintStream)GogoShellPortlet._getSessionAttribute((PortletRequest)actionRequest, "COMMAND_SESSION_ERROR_PRINT_STREAM");
        try {
            SessionMessages.add((PortletRequest)actionRequest, (String)"command", (Object)command);
            this.checkCommand(command, themeDisplay);
            Object result = commandSession.execute((CharSequence)command);
            if (result != null) {
                outputPrintStream.print(commandSession.format(result, 0));
            }
            errorPrintStream.flush();
            outputPrintStream.flush();
            SessionMessages.add((PortletRequest)actionRequest, (String)"commandOutput", (Object)outputUnsyncByteArrayOutputStream.toString());
            String errorContent = errorUnsyncByteArrayOutputStream.toString();
            if (Validator.isNotNull((String)errorContent)) {
                throw new Exception(errorContent);
            }
        }
        catch (Exception e) {
            this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            SessionErrors.add((PortletRequest)actionRequest, (String)"gogo", (Object)e);
        }
        finally {
            outputUnsyncByteArrayOutputStream.reset();
            errorUnsyncByteArrayOutputStream.reset();
        }
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        this.checkOmniAdmin();
        super.processAction(actionRequest, actionResponse);
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.checkOmniAdmin();
        super.render(renderRequest, renderResponse);
    }

    protected void checkCommand(String command, ThemeDisplay themeDisplay) throws Exception {
        Matcher matcher = _pattern.matcher(command);
        if (matcher.find()) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)themeDisplay.getLocale(), GogoShellPortlet.class);
            throw new Exception(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"the-command-x-is-not-supported", (Object)command));
        }
    }

    protected void checkOmniAdmin() throws PortletException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            PrincipalException.MustBeOmniadmin principalException = new PrincipalException.MustBeOmniadmin(permissionChecker);
            throw new PortletException((Throwable)principalException);
        }
    }

    protected void initCommandSession(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession();
        Object commandSessionAttribute = portletSession.getAttribute("COMMAND_SESSION");
        if (commandSessionAttribute instanceof CommandSession) {
            return;
        }
        UnsyncByteArrayOutputStream outputUnsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        UnsyncByteArrayOutputStream errorUnsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        PrintStream outputPrintStream = new PrintStream((OutputStream)outputUnsyncByteArrayOutputStream);
        PrintStream errorPrintStream = new PrintStream((OutputStream)errorUnsyncByteArrayOutputStream);
        CommandSession commandSession = this._commandProcessor.createSession(_emptyInputStream, (OutputStream)outputPrintStream, (OutputStream)errorPrintStream);
        commandSession.put("prompt", (Object)"g!");
        portletSession.setAttribute("COMMAND_SESSION", (Object)new TransientValue((Object)commandSession));
        portletSession.setAttribute("COMMAND_SESSION_ERROR_PRINT_STREAM", (Object)new TransientValue((Object)errorPrintStream));
        portletSession.setAttribute("COMMAND_SESSION_ERROR_STREAM", (Object)new TransientValue((Object)errorUnsyncByteArrayOutputStream));
        portletSession.setAttribute("COMMAND_SESSION_OUTPUT_PRINT_STREAM", (Object)new TransientValue((Object)outputPrintStream));
        portletSession.setAttribute("COMMAND_SESSION_OUTPUT_STREAM", (Object)new TransientValue((Object)outputUnsyncByteArrayOutputStream));
    }

    private static <T> T _getSessionAttribute(PortletRequest portletRequest, String name) {
        PortletSession portletSession = portletRequest.getPortletSession();
        Object sessionAttribute = portletSession.getAttribute(name);
        if (sessionAttribute instanceof TransientValue) {
            TransientValue transientValue = (TransientValue)sessionAttribute;
            return (T)transientValue.getValue();
        }
        return null;
    }
}

