/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.theme.westeros.bank.site.initializer.internal.servlet.taglib;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DynamicInclude.class})
public class WesterosBankTopHeadDynamicInclude
implements DynamicInclude {
    private static final String _THEME_ID = "westerosbank_WAR_westerosbanktheme";
    @Reference
    private Portal _portal;
    @Reference
    private ThemeLocalService _themeLocalService;

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group scopeGroup = themeDisplay.getScopeGroup();
        LayoutSet publicLayoutSet = scopeGroup.getPublicLayoutSet();
        LayoutSet privateLayoutSet = scopeGroup.getPrivateLayoutSet();
        if (!Objects.equals(publicLayoutSet.getThemeId(), _THEME_ID) && !Objects.equals(privateLayoutSet.getThemeId(), _THEME_ID)) {
            return;
        }
        Layout layout = themeDisplay.getLayout();
        if (!layout.isTypeControlPanel()) {
            return;
        }
        if (!Objects.equals(themeDisplay.getPpid(), "com_liferay_layout_admin_web_portlet_GroupPagesPortlet")) {
            return;
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write("<link data-senna-track=\"permanent\" href=\"");
        StringBundler sb = new StringBundler(4);
        sb.append(themeDisplay.getCDNBaseURL());
        sb.append(this._portal.getPathProxy());
        Theme theme = this._themeLocalService.getTheme(themeDisplay.getCompanyId(), _THEME_ID);
        sb.append(theme.getContextPath());
        sb.append("/css/fragments_editor.css");
        long themeLastModified = PortalWebResourcesUtil.getLastModified((String)"theme_contributor");
        String staticResourceURL = this._portal.getStaticResourceURL(httpServletRequest, sb.toString(), themeLastModified);
        printWriter.write(staticResourceURL);
        printWriter.write("\" rel=\"stylesheet\" type = \"text/css\" />\n");
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("/html/common/themes/top_head.jsp#post");
    }
}

