/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.theme.fjord.site.initializer.internal;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryModel;
import com.liferay.fragment.service.FragmentCollectionLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"site.initializer.key=fjord-site-initializer"})
public class FjordSiteInitializer
implements SiteInitializer {
    public static final String KEY = "fjord-site-initializer";
    private static final String _PATH = "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies";
    private static final String _THEME_ID = "fjord_WAR_fjordtheme";
    private static final String _THEME_NAME = "Fjord";
    private static final Log _log = LogFactoryUtil.getLog(FjordSiteInitializer.class);
    private Bundle _bundle;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private FragmentCollectionLocalService _fragmentCollectionLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateCollectionLocalService _layoutPageTemplateCollectionLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference(target="(osgi.web.symbolicname=com.liferay.frontend.theme.fjord.site.initializer)")
    private ServletContext _servletContext;
    @Reference
    private ThemeLocalService _themeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getDescription(Locale locale) {
        return "";
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        return _THEME_NAME;
    }

    public String getThumbnailSrc() {
        return this._servletContext.getContextPath() + "/images/thumbnail.png";
    }

    public void initialize(long groupId) throws InitializationException {
        try {
            ServiceContext serviceContext = this._createServiceContext(groupId);
            this._updateLogo(serviceContext);
            this._updateLookAndFeel(serviceContext);
            Folder folder = this._dlAppLocalService.addFolder(serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, _THEME_NAME, "", serviceContext);
            List<FileEntry> fileEntries = this._addFileEntries(folder.getFolderId(), serviceContext);
            Map<String, String> fileEntriesMap = this._getFileEntriesMap(fileEntries);
            FragmentCollection fragmentCollection = this._addFragmentCollection(serviceContext);
            LayoutPageTemplateCollection layoutPageTemplateCollection = this._addLayoutPageTemplateCollection(serviceContext);
            List<FragmentEntry> homeFragmentEntries = this._addFragmentEntries(fragmentCollection.getFragmentCollectionId(), fileEntriesMap, "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/home", serviceContext);
            List<FragmentEntry> downloadFragmentEntries = this._addFragmentEntries(fragmentCollection.getFragmentCollectionId(), fileEntriesMap, "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/download", serviceContext);
            homeFragmentEntries.addAll(downloadFragmentEntries);
            List<FragmentEntry> featuresFragmentEntries = this._addFragmentEntries(fragmentCollection.getFragmentCollectionId(), fileEntriesMap, "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/features", serviceContext);
            homeFragmentEntries.addAll(featuresFragmentEntries);
            this._addLayout(layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), "Home", homeFragmentEntries, "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/home", serviceContext);
            this._addLayout(layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), "Features", featuresFragmentEntries, "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/features", serviceContext);
            this._addLayout(layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), "Download", downloadFragmentEntries, "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/download", serviceContext);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new InitializationException((Throwable)e);
        }
    }

    public boolean isActive(long companyId) {
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundle = bundleContext.getBundle();
    }

    private List<FileEntry> _addFileEntries(long folderId, ServiceContext serviceContext) throws Exception {
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
        Enumeration urls = this._bundle.findEntries("com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/images", "*", false);
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            byte[] bytes = null;
            try (InputStream is = url.openStream();){
                bytes = FileUtil.getBytes((InputStream)is);
            }
            String fileName = FileUtil.getShortFileName((String)url.getPath());
            FileEntry fileEntry = this._dlAppLocalService.addFileEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), folderId, fileName, null, fileName, "", "", bytes, serviceContext);
            fileEntries.add(fileEntry);
        }
        return fileEntries;
    }

    private FragmentCollection _addFragmentCollection(ServiceContext serviceContext) throws PortalException {
        return this._fragmentCollectionLocalService.addFragmentCollection(serviceContext.getUserId(), serviceContext.getScopeGroupId(), _THEME_NAME, null, serviceContext);
    }

    private List<FragmentEntry> _addFragmentEntries(long fragmentCollectionId, Map<String, String> fileEntriesMap, String path, ServiceContext serviceContext) throws Exception {
        ArrayList<FragmentEntry> fragmentEntries = new ArrayList<FragmentEntry>();
        Enumeration enumeration = this._bundle.findEntries(path, "*.html", false);
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            String shortFileName = FileUtil.getShortFileName((String)url.getPath());
            String html = StringUtil.replace((String)StringUtil.read((InputStream)url.openStream()), (String)"$", (String)"$", fileEntriesMap);
            FragmentEntry fragmentEntry = this._fragmentEntryLocalService.addFragmentEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), fragmentCollectionId, StringUtil.upperCaseFirstLetter((String)FileUtil.stripExtension((String)shortFileName)), "", html, "", this._getPreviewFileEntryId(path, shortFileName, serviceContext), 0, serviceContext);
            fragmentEntries.add(fragmentEntry);
        }
        return fragmentEntries;
    }

    private void _addLayout(long layoutPageTemplateCollectionId, String name, List<FragmentEntry> fragmentEntries, String path, ServiceContext serviceContext) throws Exception {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._addLayoutPageTemplateEntry(layoutPageTemplateCollectionId, name, path, serviceContext);
        long[] fragmentEntryIds = ListUtil.toLongArray(fragmentEntries, FragmentEntryModel::getFragmentEntryId);
        this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), name, fragmentEntryIds, "", serviceContext);
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getSiteDefault(), name);
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("layoutPageTemplateEntryId", String.valueOf(layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
        this._layoutLocalService.addLayout(serviceContext.getUserId(), serviceContext.getScopeGroupId(), false, 0L, nameMap, new HashMap(), new HashMap(), new HashMap(), new HashMap(), "content", typeSettingsProperties.toString(), false, new HashMap(), serviceContext);
    }

    private LayoutPageTemplateCollection _addLayoutPageTemplateCollection(ServiceContext serviceContext) throws PortalException {
        return this._layoutPageTemplateCollectionLocalService.addLayoutPageTemplateCollection(serviceContext.getUserId(), serviceContext.getScopeGroupId(), _THEME_NAME, _THEME_NAME, serviceContext);
    }

    private LayoutPageTemplateEntry _addLayoutPageTemplateEntry(long layoutPageTemplateCollectionId, String name, String path, ServiceContext serviceContext) throws Exception {
        long previewFileEntryId = this._getPreviewFileEntryId(path, StringUtil.toLowerCase((String)name) + "_thumbnail.jpg", serviceContext);
        return this._layoutPageTemplateEntryLocalService.addLayoutPageTemplateEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), layoutPageTemplateCollectionId, name, 0, 0L, previewFileEntryId, 0, serviceContext);
    }

    private ServiceContext _createServiceContext(long groupId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        User user = this._userLocalService.getUser(PrincipalThreadLocal.getUserId());
        Locale locale = LocaleUtil.getSiteDefault();
        serviceContext.setLanguageId(LanguageUtil.getLanguageId((Locale)locale));
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setUserId(user.getUserId());
        serviceContext.setTimeZone(user.getTimeZone());
        return serviceContext;
    }

    private Map<String, String> _getFileEntriesMap(List<FileEntry> fileEntries) throws PortalException {
        HashMap<String, String> fileEntriesMap = new HashMap<String, String>();
        for (FileEntry fileEntry : fileEntries) {
            String fileEntryURL = DLUtil.getPreviewURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)false);
            fileEntriesMap.put(fileEntry.getFileName(), fileEntryURL);
        }
        return fileEntriesMap;
    }

    private long _getPreviewFileEntryId(String path, String fileName, ServiceContext serviceContext) throws Exception {
        StringBundler sb = new StringBundler(4);
        sb.append(path);
        sb.append("/");
        sb.append(StringUtil.split((String)fileName, (String)".")[0]);
        sb.append(".jpg");
        URL url = this._bundle.getEntry(sb.toString());
        if (url == null) {
            return 0L;
        }
        Folder folder = this._dlAppLocalService.getFolder(serviceContext.getScopeGroupId(), 0L, _THEME_NAME);
        byte[] bytes = null;
        try (InputStream is = url.openStream();){
            bytes = FileUtil.getBytes((InputStream)is);
        }
        FileEntry fileEntry = this._dlAppLocalService.addFileEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), folder.getFolderId(), fileName, null, fileName, "", "", bytes, serviceContext);
        return fileEntry.getFileEntryId();
    }

    private void _updateLogo(ServiceContext serviceContext) throws Exception {
        URL url = this._bundle.getEntry("com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/images/logo.png");
        byte[] bytes = null;
        try (InputStream is = url.openStream();){
            bytes = FileUtil.getBytes((InputStream)is);
        }
        this._layoutSetLocalService.updateLogo(serviceContext.getScopeGroupId(), false, true, bytes);
    }

    private void _updateLookAndFeel(ServiceContext serviceContext) throws PortalException {
        Theme theme = this._themeLocalService.fetchTheme(serviceContext.getCompanyId(), _THEME_ID);
        if (theme == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"No theme found for fjord_WAR_fjordtheme");
            }
            return;
        }
        this._layoutSetLocalService.updateLookAndFeel(serviceContext.getScopeGroupId(), false, _THEME_ID, "", "");
    }
}

