Liferay.Loader.define("frontend-js-web@4.0.29/liferay/util/toggle_disabled", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = toggleDisabled;

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * Toggles disabled class on received element
   * @param nodes
   * @param state
   */
  function toggleDisabled(nodes, state) {
    if (typeof nodes === 'string') {
      nodes = document.querySelectorAll(nodes);
    } else if (nodes._node) {
      nodes = [nodes._node];
    } else if (nodes._nodes) {
      nodes = nodes._nodes;
    } else if (nodes.nodeType === Node.ELEMENT_NODE) {
      nodes = [nodes];
    }

    nodes.forEach(function (node) {
      node.disabled = state;

      if (state) {
        node.classList.add('disabled');
      } else {
        node.classList.remove('disabled');
      }
    });
  }
  //# sourceMappingURL=toggle_disabled.js.map
});
//# sourceMappingURL=toggle_disabled.js.map