Liferay.Loader.define("frontend-js-web@4.0.29/liferay/util/focus_form_field", ['module', 'exports', 'require', './get_element', './in_browser_view'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = focusFormField;

  var _get_element = _interopRequireDefault(require("./get_element"));

  var _in_browser_view = _interopRequireDefault(require("./in_browser_view"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function getDisabledParents(element) {
    var result = [];

    while (element.parentElement) {
      if (element.parentElement.getAttribute('disabled')) {
        result.push(element.parentElement);
      }

      element = element.parentElement;
    }

    return result;
  }

  function focusFormField(element) {
    element = (0, _get_element["default"])(element);

    if ((0, _in_browser_view["default"])(element)) {
      var disabledParents = getDisabledParents(element);
      var focusable = !element.getAttribute('disabled') && element.offsetWidth > 0 && element.offsetHeight > 0 && !disabledParents.length;
      var form = element.closest('form');

      if (!form || focusable) {
        element.focus();
      } else if (form) {
        var portletName = form.getAttribute('data-fm-namespace');
        var formReadyEventName = portletName + 'formReady';

        var formReadyHandler = function formReadyHandler(event) {
          var elFormName = form.getAttribute('name');
          var formName = event.formName;

          if (elFormName === formName) {
            element.focus();
            Liferay.detach(formReadyEventName, formReadyHandler);
          }
        };

        Liferay.on(formReadyEventName, formReadyHandler);
      }
    }
  }
  //# sourceMappingURL=focus_form_field.js.map
});
//# sourceMappingURL=focus_form_field.js.map