Liferay.Loader.define("frontend-js-web@4.0.29/liferay/portlet/register.es", ['module', 'exports', 'require', './PortletInit.es', './portlet_util.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.register = void 0;

  var _PortletInit = _interopRequireDefault(require("./PortletInit.es"));

  var _portlet_util = require("./portlet_util.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * Registers a portlet client with the portlet hub.
   * @param {string} portletId The unique portlet identifier
   * @return {Promise} A Promise object. Returns an {@link PortletInit} object
   * containing functions for use by the portlet client on successful resolution.
   * Returns an Error object containing a descriptive message on failure.
   * @review
   */
  var register = function register(portletId) {
    (0, _portlet_util.validateArguments)(arguments, 1, 1, ['string']);
    var pageRenderState = global.portlet.data.pageRenderState;
    return new Promise(function (resolve, reject) {
      if ((0, _portlet_util.validatePortletId)(pageRenderState, portletId)) {
        resolve(new _PortletInit["default"](portletId));
      } else {
        reject(new Error('Invalid portlet ID'));
      }
    });
  };

  exports.register = register;
  var _default = register;
  exports["default"] = _default;
  //# sourceMappingURL=register.es.js.map
});
//# sourceMappingURL=register.es.js.map