Liferay.Loader.define("frontend-js-web@4.0.29/liferay/portal/tabs.es", ['module', 'exports', 'require', '../util/to_char_code.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.showTab = showTab;
  exports.applyTabSelectionDOMChanges = applyTabSelectionDOMChanges;

  var _to_char_code = _interopRequireDefault(require("../util/to_char_code.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var EVENT_SHOW_TAB = 'showTab';
  /**
   * Prepares and fires the an event that will show a tab
   * @param {String} namespace The portlet's namespace
   * @param {Array} names Names of all tabs
   * @param {String} id Tab id.
   * @param {Function} callback The callback function.
   */

  function showTab(namespace, names, id, callback) {
    var namespacedId = namespace + (0, _to_char_code["default"])(id);
    var selectedTab = document.getElementById(namespacedId + 'TabsId');
    var selectedTabSection = document.getElementById(namespacedId + 'TabsSection');

    if (selectedTab && selectedTabSection) {
      var details = {
        id: id,
        names: names,
        namespace: namespace,
        selectedTab: selectedTab,
        selectedTabSection: selectedTabSection
      };

      if (callback && typeof callback === 'function') {
        callback.call(this, namespace, names, id, details);
      }

      try {
        Liferay.on(EVENT_SHOW_TAB, applyTabSelectionDOMChanges);
        Liferay.fire(EVENT_SHOW_TAB, details);
      } finally {
        Liferay.detach(EVENT_SHOW_TAB, applyTabSelectionDOMChanges);
      }
    }
  }
  /**
   * Applies DOM changes that represent tab selection
   * @param {String} namespace The portlet's namespace
   * @param {Array} names Names of all tabs
   * @param {String} id Tab id.
   * @param {HTMLElement} selectedTab Selected tab element
   * @param {HTMLElement} selectedTabSection Selected tab section element
   */

  function applyTabSelectionDOMChanges(_ref) {
    var id = _ref.id,
        names = _ref.names,
        namespace = _ref.namespace,
        selectedTab = _ref.selectedTab,
        selectedTabSection = _ref.selectedTabSection;
    var selectedTabLink = selectedTab.querySelector('a');

    if (selectedTab && selectedTabLink) {
      var activeTab = selectedTab.parentElement.querySelector('.active');

      if (activeTab) {
        activeTab.classList.remove('active');
      }

      selectedTabLink.classList.add('active');
    }

    if (selectedTabSection) {
      selectedTabSection.classList.remove('hide');
    }

    var tabTitle = document.getElementById(namespace + 'dropdownTitle');

    if (tabTitle && selectedTabLink) {
      tabTitle.innerHTML = selectedTabLink.textContent;
    }

    names.splice(names.indexOf(id), 1);
    var tabSection;

    for (var i = 0; i < names.length; i++) {
      tabSection = document.getElementById(namespace + (0, _to_char_code["default"])(names[i]) + 'TabsSection');

      if (tabSection) {
        tabSection.classList.add('hide');
      }
    }
  }
  //# sourceMappingURL=tabs.es.js.map
});
//# sourceMappingURL=tabs.es.js.map