Liferay.Loader.define("frontend-js-web@4.0.29/liferay/DynamicInlineScroll.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-events', './PortletBase.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _PortletBase2 = _interopRequireDefault(require("./PortletBase.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Appends list item elements to dropdown menus with inline-scrollers on scroll
   * events to improve page loading performance.
   *
   * @extends {Component}
   */
  var DynamicInlineScroll = /*#__PURE__*/function (_PortletBase) {
    _inherits(DynamicInlineScroll, _PortletBase);

    function DynamicInlineScroll() {
      _classCallCheck(this, DynamicInlineScroll);

      return _possibleConstructorReturn(this, _getPrototypeOf(DynamicInlineScroll).apply(this, arguments));
    }

    _createClass(DynamicInlineScroll, [{
      key: "created",

      /**
       * @inheritDoc
       */
      value: function created() {
        this.eventHandler_ = new _metalEvents.EventHandler();
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "attached",
      value: function attached() {
        var rootNode = this.rootNode;
        rootNode = rootNode || document;
        this.eventHandler_.add(_metalDom["default"].delegate(rootNode, 'scroll', 'ul.pagination ul.inline-scroller', this.onScroll_.bind(this)));
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "detached",
      value: function detached() {
        _get(_getPrototypeOf(DynamicInlineScroll.prototype), "detached", this).call(this);

        this.eventHandler_.removeAllListeners();
      }
      /**
       * Dynamically adds list item elements to the dropdown menu.
       *
       * @param {element} listElement The list element's DOM node.
       * @param {number} pageIndex The Index of the page with an inline-scroller.
       * @protected
       */

    }, {
      key: "addListItem_",
      value: function addListItem_(listElement, pageIndex) {
        var listItem = document.createElement('li');

        _metalDom["default"].append(listItem, "<a href=\"".concat(this.getHREF_(pageIndex), "\">").concat(pageIndex, "</a>"));

        pageIndex++;
        listElement.appendChild(listItem);
        listElement.setAttribute('data-page-index', pageIndex);
        this.eventHandler_.add(_metalDom["default"].on(listItem, 'click', this.handleListItemClick_.bind(this)));
      }
      /**
       * Returns the <code>href</code> attribute value for each page.
       *
       * @param {number} pageIndex The Index of the page.
       * @protected
       * @return {string} The <code>href</code> value as a string.
       */

    }, {
      key: "getHREF_",
      value: function getHREF_(pageIndex) {
        var curParam = this.curParam,
            formName = this.formName,
            jsCall = this.jsCall,
            namespace = this.namespace,
            url = this.url,
            urlAnchor = this.urlAnchor;
        var href = "javascript:document.".concat(formName, ".").concat(namespace).concat(curParam, ".value = \"").concat(pageIndex, "; ").concat(jsCall);

        if (this.url !== null) {
          href = "".concat(url).concat(namespace).concat(curParam, "=").concat(pageIndex).concat(urlAnchor);
        }

        return href;
      }
      /**
       * Returns the numerical value of the parameter passed in.
       *
       * @param {string|!Object} val The string or object to be converted to a number.
       * @protected
       * @return {number} The parameter's numberical value.
       */

    }, {
      key: "getNumber_",
      value: function getNumber_(val) {
        return Number(val);
      }
      /**
       * Handles the click event of the dynmaically added list item, preventing
       * the default behavior and submitting the search container form.
       *
       * @param {Event} event The click event of the dynamically added list item.
       * @protected
       */

    }, {
      key: "handleListItemClick_",
      value: function handleListItemClick_(event) {
        if (this.forcePost) {
          event.preventDefault();
          var curParam = this.curParam,
              namespace = this.namespace,
              randomNamespace = this.randomNamespace;
          var form = document.getElementById(randomNamespace + namespace + 'pageIteratorFm');
          form.elements[namespace + curParam].value = event.currentTarget.textContent;
          form.submit();
        }
      }
      /**
       * An event triggered when a dropdown menu with an inline-scroller is
       * scrolled. This dynamically adds list item elements to the dropdown menu
       * as it is scrolled down.
       *
       * @param {Event} event The scroll event triggered by scrolling a dropdown
       *        menu with an inline-scroller.
       * @protected
       */

    }, {
      key: "onScroll_",
      value: function onScroll_(event) {
        var cur = this.cur,
            initialPages = this.initialPages,
            pages = this.pages;
        var target = event.target;
        var pageIndex = this.getNumber_(target.getAttribute('data-page-index'));
        var pageIndexMax = this.getNumber_(target.getAttribute('data-max-index'));

        if (pageIndex === 0) {
          var pageIndexCurrent = this.getNumber_(target.getAttribute('data-current-index'));

          if (pageIndexCurrent === 0) {
            pageIndex = initialPages;
          } else {
            pageIndex = pageIndexCurrent + initialPages;
          }
        }

        if (pageIndexMax === 0) {
          pageIndexMax = pages;
        }

        if (cur <= pages && pageIndex < pageIndexMax && target.getAttribute('scrollTop') >= target.getAttribute('scrollHeight') - 300) {
          this.addListItem_(target, pageIndex);
        }
      }
    }]);

    return DynamicInlineScroll;
  }(_PortletBase2["default"]);
  /**
   * State definition.
   *
   * @ignore
   * @static
   * @type {!Object}
   */

  DynamicInlineScroll.STATE = {
    /**
     * Current page index.
     *
     * @instance
     * @memberof DynamicInlineScroll
     * @type {string}
     */
    cur: {
      setter: 'getNumber_',
      validator: _metal["default"].isString
    },

    /**
     * URL parameter of the current page.
     *
     * @instance
     * @memberof DynamicInlineScroll
     * @type {string}
     */
    curParam: {
      validator: _metal["default"].isString
    },

    /**
     * Forces a form post when a page on the dropdown menu is clicked.
     *
     * @instance
     * @memberof DynamicInlineScroll
     * @type {boolean}
     */
    forcePost: {
      validator: _metal["default"].isBoolean
    },

    /**
     * Form name.
     *
     * @instance
     * @memberof DynamicInlineScroll
     * @type {string}
     */
    formName: {
      validator: _metal["default"].isString
    },

    /**
     * Number of pages loaded to the inline-scroll dropdown menu for the first
     * page load.
     *
     * @instance
     * @memberof DynamicInlineScroll
     * @type {string}
     */
    initialPages: {
      setter: 'getNumber_',
      validator: _metal["default"].isString
    },

    /**
     * JavaScript call.
     *
     * @instance
     * @memberof DynamicInlineScroll
     * @type {string}
     */
    jsCall: {
      validator: _metal["default"].isString
    },

    /**
     * Namespace.
     *
     * @instance
     * @memberof DynamicInlineScroll
     * @type {string}
     */
    namespace: {
      validator: _metal["default"].isString
    },

    /**
     * Total number of pages.
     *
     * @instance
     * @memberof DynamicInlineScroll
     * @type {string}
     */
    pages: {
      setter: 'getNumber_',
      validator: _metal["default"].isString
    },

    /**
     * Random namespace.
     *
     * @instance
     * @memberof DynamicInlineScroll
     * @type {string}
     */
    randomNamespace: {
      validator: _metal["default"].isString
    },

    /**
     * URL.
     *
     * @instance
     * @memberof DynamicInlineScroll
     * @type {string}
     */
    url: {
      validator: _metal["default"].isString
    },

    /**
     * URL anchor.
     *
     * @instance
     * @memberof DynamicInlineScroll
     * @type {string}
     */
    urlAnchor: {
      validator: _metal["default"].isString
    }
  };
  var _default = DynamicInlineScroll;
  exports["default"] = _default;
  //# sourceMappingURL=DynamicInlineScroll.es.js.map
});
//# sourceMappingURL=DynamicInlineScroll.es.js.map