/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
'use strict';

Liferay.Loader.define("frontend-js-web@3.0.53/liferay/keyboard-focus/KeyboardFocusManager.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-events'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _metalEvents = _interopRequireDefault(require("frontend-js-metal-web$metal-events"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Listens to keyboard events and uses them to move focus between different
   * elements from a component (via the arrow keys for example).
   * By default `KeyboardFocusManager` will assume that all focusable elements
   * in the component will have refs that follow the pattern in
   * KeyboardFocusManager.REF_REGEX, which includes a position number. The arrow
   * keys will then automatically move between elements by
   * incrementing/decrementing this position.
   * It's possible to fully customize this behavior by passing a function to
   * `setFocusHandler`. For more details check this function's docs.
   */
  var KeyboardFocusManager = /*#__PURE__*/function (_EventEmitter) {
    _inherits(KeyboardFocusManager, _EventEmitter);

    /**
     * Constructor for `KeyboardFocusManager`.
     * @param {!Component} component
     * @param {string=} opt_selector
     */
    function KeyboardFocusManager(component, opt_selector) {
      var _this;

      _classCallCheck(this, KeyboardFocusManager);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(KeyboardFocusManager).call(this));
      _this.component_ = component;
      _this.selector_ = opt_selector || '*';
      _this.handleKey_ = _this.handleKey_.bind(_assertThisInitialized(_this));
      return _this;
    }
    /**
     * Builds a ref string for the given position.
     * @param {string} prefix
     * @param {number|string} position
     * @return {string}
     * @protected
     */

    _createClass(KeyboardFocusManager, [{
      key: "buildRef_",
      value: function buildRef_(prefix, position) {
        return prefix + position;
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "disposeInternal",
      value: function disposeInternal() {
        _get(_getPrototypeOf(KeyboardFocusManager.prototype), "disposeInternal", this).call(this);

        this.stop();
        this.component_ = null;
        this.selector_ = null;
      }
      /**
       * Gets the next focusable element, that is, the next element that doesn't
       * have the `data-unfocusable` attribute set to `true`.
       * @param {string} prefix
       * @param {number} position
       * @param {number} increment
       * @return {string}
       * @protected
       */

    }, {
      key: "getNextFocusable_",
      value: function getNextFocusable_(prefix, position, increment) {
        var initialPosition = position;
        var element;
        var ref;

        do {
          position = this.increment_(position, increment);
          ref = this.buildRef_(prefix, position);
          element = this.component_.refs[ref];
        } while (this.isFocusable_(element) && position !== initialPosition);

        return element ? ref : null;
      }
      /**
       * Handles a `keydown` event. Decides if a new element should be focused
       * according to the key that was pressed.
       * @param {!Event} event
       * @protected
       */

    }, {
      key: "handleKey_",
      value: function handleKey_(event) {
        var element = this.focusHandler_ && this.focusHandler_(event);

        if (!this.focusHandler_ || element === true) {
          element = this.handleKeyDefault_(event);
        }

        var originalValue = element;

        if (!_metal["default"].isElement(element)) {
          element = this.component_.refs[element];
        }

        if (element) {
          element.focus();
          this.emit(KeyboardFocusManager.EVENT_FOCUSED, {
            element: element,
            ref: _metal["default"].isString(originalValue) ? originalValue : null
          });
        }
      }
      /**
       * Handles a key press according to the default behavior. Assumes that all
       * focusable elements in the component will have refs that follow the pattern
       * in KeyboardFocusManager.REF_REGEX, which includes a position number. The
       * arrow keys will then automatically move between elements by
       * incrementing/decrementing the position.
       * @param {!Event} event
       * @protected
       */

    }, {
      key: "handleKeyDefault_",
      value: function handleKeyDefault_(event) {
        var ref = event.delegateTarget.getAttribute('ref');
        var matches = KeyboardFocusManager.REF_REGEX.exec(ref);

        if (!matches) {
          return;
        }

        var position = parseInt(matches[1], 10);
        var prefix = ref.substr(0, ref.length - matches[1].length);

        switch (event.keyCode) {
          case 37:
          case 38:
            // Left/up arrow keys will focus the previous element.
            return this.getNextFocusable_(prefix, position, -1);

          case 39:
          case 40:
            // Right/down arrow keys will focus the next element.
            return this.getNextFocusable_(prefix, position, 1);

          default:
        }
      }
      /**
       * Increments the given position, making sure to follow circular rules if
       * enabled.
       * @param {number} position
       * @param {number} increment
       * @return {number}
       * @protected
       */

    }, {
      key: "increment_",
      value: function increment_(position, increment) {
        var size = this.circularLength_;
        position += increment;

        if (_metal["default"].isNumber(size)) {
          if (position < 0) {
            position = size - 1;
          } else if (position >= size) {
            position = 0;
          }
        }

        return position;
      }
      /**
       * Checks if the given element is focusable.
       * @param {Element} element
       * @return {boolean}
       * @protected
       */

    }, {
      key: "isFocusable_",
      value: function isFocusable_(element) {
        return element && element.getAttribute('data-unfocusable') === 'true';
      }
      /**
       * Sets the length of the focusable elements. If a number is passed, the
       * default focusing behavior will follow a circular pattern, going from the
       * last to the first element, and vice versa.
       * @param {?number} circularLength
       * @chainable
       */

    }, {
      key: "setCircularLength",
      value: function setCircularLength(circularLength) {
        this.circularLength_ = circularLength;
        return this;
      }
      /**
       * Sets a handler function that will be called to decide which element should
       * be focused according to the key that was pressed. It will receive the key
       * event and should return one of the following:
       *   - `true`, if the default behavior should be triggered instead.
       *   - A string, representing a `ref` to the component element that should be
       *       focused.
       *   - The element itself that should be focused.
       *   - Anything else, if nothing should be focused (skipping default behavior
       *       too).
       * @param {function} focusHandler
       * @chainable
       */

    }, {
      key: "setFocusHandler",
      value: function setFocusHandler(focusHandler) {
        this.focusHandler_ = focusHandler;
        return this;
      }
      /**
       * Starts listening to keyboard events and handling element focus.
       * @chainable
       */

    }, {
      key: "start",
      value: function start() {
        if (!this.handle_) {
          this.handle_ = this.component_.delegate('keydown', this.selector_, this.handleKey_);
        }

        return this;
      }
      /**
       * Stops listening to keyboard events and handling element focus.
       * @chainable
       */

    }, {
      key: "stop",
      value: function stop() {
        if (this.handle_) {
          this.handle_.removeListener();
          this.handle_ = null;
        }

        return this;
      }
    }]);

    return KeyboardFocusManager;
  }(_metalEvents["default"]); // Event emitted when a selected element was focused via the keyboard.


  KeyboardFocusManager.EVENT_FOCUSED = 'focused'; // The regex used to extract the position from an element's ref.

  KeyboardFocusManager.REF_REGEX = /.+-(\d+)$/;
  var _default = KeyboardFocusManager;
  exports["default"] = _default;
  //# sourceMappingURL=KeyboardFocusManager.es.js.map
});
//# sourceMappingURL=KeyboardFocusManager.es.js.map