Liferay.Loader.define("frontend-js-web@3.0.53/liferay/compat/treeview/Treeview.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './../../keyboard-focus/KeyboardFocusManager.es', './Treeview.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.Treeview = void 0;

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _KeyboardFocusManager = _interopRequireDefault(require("./../../keyboard-focus/KeyboardFocusManager.es"));

  var _Treeview = _interopRequireDefault(require("./Treeview.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Treeview component.
   * @deprecated since 7.2
   */
  var Treeview = /*#__PURE__*/function (_Component) {
    _inherits(Treeview, _Component);

    function Treeview() {
      _classCallCheck(this, Treeview);

      return _possibleConstructorReturn(this, _getPrototypeOf(Treeview).apply(this, arguments));
    }

    _createClass(Treeview, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        this.keyboardFocusManager_ = new _KeyboardFocusManager["default"](this, 'li').setFocusHandler(this.handleNextFocus_.bind(this)).start();
        this.keyboardFocusManager_.on(_KeyboardFocusManager["default"].EVENT_FOCUSED, this.handleKeyboardFocused_.bind(this));
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this.keyboardFocusManager_.dispose();
        this.keyboardFocusManager_ = null;
      }
      /**
       * Gets the node object from the `nodes` state that is located at the given
       * index path.
       * @param {!Array<number>} path An array of indexes indicating where the
       *   searched node is located inside the `nodes` state.
       * @return {!Object}
       */

    }, {
      key: "getNodeObj",
      value: function getNodeObj(path) {
        var obj = this.nodes[path[0]];

        for (var i = 1; i < path.length; i++) {
          obj = obj.children[path[i]];
        }

        return obj;
      }
      /**
       * Gets the treeview path for a given node.
       * @param {!Element} node
       * @return {!Array<string>}
       * @protected
       */

    }, {
      key: "getPath_",
      value: function getPath_(node) {
        return node.getAttribute('data-treeview-path').split('-');
      }
      /**
       * Handles the `focused` event from `KeyboardFocusManager`. Stores the ref
       * of the last focused tree item so that we can retain it in the tab order
       * when the user leaves the tree.
       * @param {!Object} data
       * @protected
       */

    }, {
      key: "handleKeyboardFocused_",
      value: function handleKeyboardFocused_(data) {
        this.lastFocusedRef_ = data.ref;
      }
      /**
       * Handles the left arrow being pressed. If the node is expanded, it will be
       * closed. If it's closed, its parent's ref will be returned so it can be
       * focused by `KeyboardFocusManager`.
       * @param {!Array<string>} path
       * @param {!Object} obj
       * @return {?string}
       * @protected
       */

    }, {
      key: "handleLeftArrow_",
      value: function handleLeftArrow_(path, obj) {
        if (obj.expanded) {
          obj.expanded = false;
          this.nodes = this.nodes;
        } else if (path.length > 1) {
          path.pop();
          return Treeview.NODE_REF_PREFIX + path.join('-');
        }
      }
      /**
       * Handles focus through keyboard.
       * @param {!Event} event
       * @return {boolean|string|Element}
       * @protected
       */

    }, {
      key: "handleNextFocus_",
      value: function handleNextFocus_(event) {
        event.stopPropagation();
        var path = this.getPath_(event.delegateTarget);
        var obj = this.getNodeObj(path);

        switch (event.keyCode) {
          case 37:
            return this.handleLeftArrow_(path, obj);

          case 39:
            return this.handleRightArrow_(path, obj);

          default:
            // Use default behavior for other keys (like up/down arrows).
            return true;
        }
      }
      /**
       * This is called when one of this tree view's nodes is clicked.
       * @param {!Event} event
       * @protected
       */

    }, {
      key: "handleNodeClicked_",
      value: function handleNodeClicked_(event) {
        this.toggleExpandedState_(event.delegateTarget.parentNode.parentNode);
      }
      /**
       * This is called when one of this tree view's nodes receives a keypress.
       * If the pressed key is ENTER or SPACE, the node's expanded state will be toggled.
       * @param {!Event} event
       * @protected
       */

    }, {
      key: "handleNodeKeyUp_",
      value: function handleNodeKeyUp_(event) {
        if (event.keyCode === 13 || event.keyCode === 32) {
          this.toggleExpandedState_(event.delegateTarget);
          event.stopPropagation();
        }
      }
      /**
       * Handles the right arrow being pressed. If the node is closed, it will be
       * expanded. If it's already expanded, the ref of its first child will be
       * returned so it can be focused by `KeyboardFocusManager`.
       * @param {!Array<string>} path
       * @param {!Object} obj
       * @return {?string}
       * @protected
       */

    }, {
      key: "handleRightArrow_",
      value: function handleRightArrow_(path, obj) {
        if (obj.expanded) {
          path.push(0);
          return Treeview.NODE_REF_PREFIX + path.join('-');
        } else if (obj.children) {
          obj.expanded = true;
          this.nodes = this.nodes;
        }
      }
      /**
       * Toggles the expanded state for the given tree node.
       * @param {!Element} node
       * @protected
       */

    }, {
      key: "toggleExpandedState_",
      value: function toggleExpandedState_(node) {
        var nodeObj = this.getNodeObj(this.getPath_(node));
        nodeObj.expanded = !nodeObj.expanded;
        this.nodes = this.nodes;
      }
    }]);

    return Treeview;
  }(_metalComponent["default"]);

  exports.Treeview = Treeview;

  _metalSoy["default"].register(Treeview, _Treeview["default"]); // The prefix used for tree item nodes' refs.


  Treeview.NODE_REF_PREFIX = 'node-';
  /**
   * Treeview state definition.
   * @type {!Object}
   * @static
   */

  Treeview.STATE = {
    /**
     * The ref of the last item that has been focused, so that we can retain only
     * that node in the tab order.
     * @type {string}
     */
    lastFocusedRef_: {
      internal: true,
      validator: _metal["default"].isString
    },

    /**
     * This tree view's nodes. Each node should have a name, and can optionally
     * have nested children nodes. It should also indicate if its children are
     * expanded or not.
     * @type {Array<!{children: Array, expanded: boolean?, name: string}>}
     * @default []
     */
    nodes: {
      validator: Array.isArray,
      valueFn: function valueFn() {
        return [];
      }
    }
  };
  var _default = Treeview;
  exports["default"] = _default;
  //# sourceMappingURL=Treeview.es.js.map
});
//# sourceMappingURL=Treeview.es.js.map