"use strict";

Liferay.Loader.define("frontend-js-web@3.0.12/liferay/util/navigate.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = _default;

  /**
   * Performs navigation to the given url. If SPA is enabled, it will route the
   * request through the SPA engine. If not, it will simple change the document
   * location.
   * @param {!string} url Destination URL to navigate
   * @param {?object} listeners Object with key-value pairs with callbacks for
   * specific page lifecycle events
   * @review
   */
  function _default(url, listeners) {
    if (Liferay.SPA) {
      Liferay.SPA.app.navigate(url);

      if (listeners) {
        Object.keys(listeners).forEach(function (key) {
          Liferay.once(key, listeners[key]);
        });
      }
    } else {
      window.location.href = url;
    }
  }
  //# sourceMappingURL=navigate.es.js.map
});
//# sourceMappingURL=navigate.es.js.map