"use strict";

Liferay.Loader.define("frontend-js-web@3.0.12/liferay/compat/tooltip/Tooltip.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-soy', './TooltipBase.es', './Tooltip.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  Object.defineProperty(exports, "TooltipBase", {
    enumerable: true,
    get: function get() {
      return _TooltipBase2.default;
    }
  });
  exports.Tooltip = exports.default = void 0;

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _TooltipBase2 = _interopRequireDefault(require("./TooltipBase.es"));

  var _Tooltip = _interopRequireDefault(require("./Tooltip.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Tooltip component.
   */
  var Tooltip =
  /*#__PURE__*/
  function (_TooltipBase) {
    _inherits(Tooltip, _TooltipBase);

    function Tooltip() {
      _classCallCheck(this, Tooltip);

      return _possibleConstructorReturn(this, _getPrototypeOf(Tooltip).apply(this, arguments));
    }

    _createClass(Tooltip, [{
      key: "hideCompletely_",

      /**
       * Hides the alert completely (with display "none"). This is called after the
       * hiding animation is done.
       * @protected
       */
      value: function hideCompletely_() {
        if (!this.isDisposed() && this.element && !this.visible) {
          this.element.style.display = 'none';
        }
      }
      /**
       * State synchronization logic for `visible`. Updates the element's opacity,
       * since bootstrap uses opacity instead of display for tooltip visibility.
       * @param {boolean} visible
       */

    }, {
      key: "syncVisible",
      value: function syncVisible(visible) {
        if (!visible) {
          _metalDom.default.once(this.element, 'animationend', this.hideCompletely_.bind(this));

          _metalDom.default.once(this.element, 'transitionend', this.hideCompletely_.bind(this));
        } else {
          this.element.style.display = '';
        }

        this.element.style.opacity = visible ? 1 : '';

        _get(_getPrototypeOf(Tooltip.prototype), "syncVisible", this).call(this, visible);
      }
    }]);

    return Tooltip;
  }(_TooltipBase2.default);

  exports.Tooltip = Tooltip;

  _metalSoy.default.register(Tooltip, _Tooltip.default);
  /**
   * @inheritDoc
   * @see `Align` class.
   * @static
   */

  Tooltip.Align = _TooltipBase2.default.Align;
  var _default = Tooltip;
  exports.default = _default;
  //# sourceMappingURL=Tooltip.es.js.map
});
//# sourceMappingURL=Tooltip.es.js.map