'use strict';

Liferay.Loader.define("frontend-js-web@2.0.6/liferay/portlet/portlet_util.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.validateState = exports.validateParameters = exports.validateForm = exports.getUrl = exports.getUpdatedPublicRenderParameters = exports.generatePortletModeAndWindowStateString = exports.encodeFormAsString = exports.decodeUpdateString = undefined;

	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
		return typeof obj;
	} : function (obj) {
		return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	};

	var _metal = require("frontend-js-metal-web$metal");

	function _toConsumableArray(arr) {
		if (Array.isArray(arr)) {
			for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
				arr2[i] = arr[i];
			}return arr2;
		} else {
			return Array.from(arr);
		}
	}

	// Constants for URL generation

	var CACHE_LEVEL = 'p_p_cacheability';

	var HUB = 'p_p_hub';

	var HUB_ACTION = '0';

	var HUB_PARTIAL_ACTION = '1';

	var HUB_RESOURCE = '2';

	var PORTLET_MODE = 'p_p_mode';

	var PUBLIC_RENDER_PARAM = 'p_r_p_';

	var RENDER_PARAM = 'priv_r_p_';

	var RESOURCE_ID = 'p_p_resource_id';

	var TOKEN_DELIM = '&';

	var VALUE_ARRAY_EMPTY = '';

	var VALUE_DELIM = '=';

	var VALUE_NULL = '';

	var WINDOW_STATE = 'p_p_state';

	/**
  * Decodes the update strings.
  * The update string is a JSON object containing the entire page state.
  * This decoder returns an object containing the portlet data for portlets whose
  * state has changed as compared to the current page state.
  * @param {Object} pageRenderState The page render state.
  * @param {string} updateString The update string to decode.
  * @return {Object}
  * @review
  */

	var decodeUpdateString = function decodeUpdateString(pageRenderState, updateString) {
		var portlets = {};

		try {
			var newRenderState = JSON.parse(updateString);
			var _portlets = pageRenderState.portlets;

			if (newRenderState.portlets && _portlets) {
				var keys = Object.keys(_portlets);

				var _iteratorNormalCompletion = true;
				var _didIteratorError = false;
				var _iteratorError = undefined;

				try {
					for (var _iterator = keys[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
						var key = _step.value;

						var newState = newRenderState.portlets[key].state;
						var oldState = _portlets[key].state;

						if (!newState || !oldState) {
							throw new Error('Invalid update string.\nold state=' + oldState + '\nnew state=' + newState);
						}

						if (stateChanged(newState, key)) {
							_portlets[key] = newRenderState.portlets[key];
						}
					}
				} catch (err) {
					_didIteratorError = true;
					_iteratorError = err;
				} finally {
					try {
						if (!_iteratorNormalCompletion && _iterator.return) {
							_iterator.return();
						}
					} finally {
						if (_didIteratorError) {
							throw _iteratorError;
						}
					}
				}
			}
		} catch (e) {}

		return portlets;
	};

	/**
  * Function to extract data from form and encode
  * it as an 'application/x-www-form-urlencoded' string.
  * @param {string} portletId The portlet ID.
  * @param {HTMLFormElement} form Form to be submitted.
  * @review
  */

	var encodeFormAsString = function encodeFormAsString(portletId, form) {
		var parameters = [];

		var _loop = function _loop(i) {
			var element = form.elements[i];
			var name = element.name;
			var tag = element.nodeName.toUpperCase();
			var type = tag === 'INPUT' ? element.type.toUpperCase() : '';
			var value = element.value;

			if (name && !element.disabled && type !== 'FILE') {
				if (tag === 'SELECT' && element.multiple) {
					var options = [].concat(_toConsumableArray(element.options));

					options.forEach(function (opt) {
						if (opt.checked) {
							var _value = opt.value;

							var parameter = encodeURIComponent(portletId + name) + '=' + encodeURIComponent(_value);

							parameters.push(parameter);
						}
					});
				} else if (type !== 'CHECKBOX' && type !== 'RADIO' || element.checked) {
					var param = encodeURIComponent(portletId + name) + '=' + encodeURIComponent(value);
					parameters.push(param);
				}
			}
		};

		for (var i = 0; i < form.elements.length; i++) {
			_loop(i);
		}

		return parameters.join('&');
	};

	/**
  * Helper for encoding a multi valued parameter.
  * @param {string} name The parameter's name.
  * @param {Array.<string>} values The parameter's value.
  * @return {string}
  * @review
  */

	var encodeParameter = function encodeParameter(name, values) {
		var str = '';

		if (Array.isArray(values)) {
			if (values.length === 0) {
				str += TOKEN_DELIM + encodeURIComponent(name) + VALUE_DELIM + VALUE_ARRAY_EMPTY;
			} else {
				var _iteratorNormalCompletion2 = true;
				var _didIteratorError2 = false;
				var _iteratorError2 = undefined;

				try {
					for (var _iterator2 = values[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
						var _value2 = _step2.value;

						str += TOKEN_DELIM + encodeURIComponent(name);
						if (_value2 === null) {
							str += VALUE_DELIM + VALUE_NULL;
						} else {
							str += VALUE_DELIM + encodeURIComponent(_value2);
						}
					}
				} catch (err) {
					_didIteratorError2 = true;
					_iteratorError2 = err;
				} finally {
					try {
						if (!_iteratorNormalCompletion2 && _iterator2.return) {
							_iterator2.return();
						}
					} finally {
						if (_didIteratorError2) {
							throw _iteratorError2;
						}
					}
				}
			}
		}
		return str;
	};

	/**
  * Helper for generating parameter strings for the URL
  * @param {Object} pageRenderState The page render state.
  * @param {string} portletId The portlet ID.
  * @param {string} name The parameter's name.
  * @param {string} type The parameter's type.
  * @param {string} group The parameter's group.
  * @review
  */

	var generateParameterString = function generateParameterString(pageRenderState, portletId, name, type, group) {
		var str = '';

		if (pageRenderState.portlets && pageRenderState.portlets[portletId]) {
			var portletData = pageRenderState.portlets[portletId];

			if (portletData && portletData.state && portletData.state.parameters) {
				var values = portletData.state.parameters[name];

				if (values !== undefined) {

					// If values are present, encode the mutlivalued parameter string

					if (type === PUBLIC_RENDER_PARAM) {
						str += encodeParameter(group, values);
					} else if (type === RENDER_PARAM) {
						str += encodeParameter(RENDER_PARAM + name, values);
					} else {
						str += encodeParameter(portletId + name, values);
					}
				}
			}
		}

		return str;
	};

	/**
  * Helper for generating portlet mode & window state strings for the URL.
  * @param {Object} pageRenderState The page render state.
  * @param {string} portletId The portlet ID.
  * @return {string}
  * @review
  */

	var generatePortletModeAndWindowStateString = function generatePortletModeAndWindowStateString(pageRenderState, portletId) {
		var str = '';

		if (pageRenderState.portlets) {
			var portletData = pageRenderState.portlets[portletId];

			if (portletData.state) {
				var state = portletData.state;

				str += TOKEN_DELIM + PORTLET_MODE + VALUE_DELIM + encodeURIComponent(state.portletMode);
				str += TOKEN_DELIM + WINDOW_STATE + VALUE_DELIM + encodeURIComponent(state.windowState);
			}
		}

		return str;
	};

	/**
  * Gets the updated public parameters for the given portlet ID and new render state.
  * Returns an object whose properties are the group indexes of the
  * updated public parameters. The values are the new public parameter values.
  * @param {Object} pageRenderState The page render state.
  * @param {string} portletId The portlet ID.
  * @param {RenderState} state The new render state.
  * @return {Object} Object containing the updated public render parameters.
  * @review
  */

	var getUpdatedPublicRenderParameters = function getUpdatedPublicRenderParameters(pageRenderState, portletId, state) {
		var publicRenderParameters = {};

		if (pageRenderState && pageRenderState.portlets) {

			var portletData = pageRenderState.portlets[portletId];

			if (portletData && portletData.pubParams) {

				var portletPublicParameters = portletData.pubParams;

				var keys = Object.keys(portletPublicParameters);

				var _iteratorNormalCompletion3 = true;
				var _didIteratorError3 = false;
				var _iteratorError3 = undefined;

				try {
					for (var _iterator3 = keys[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
						var key = _step3.value;

						if (!isParameterInStateEqual(pageRenderState, portletId, state, key)) {
							var group = portletPublicParameters[key];

							publicRenderParameters[group] = state.parameters[name];
						}
					}
				} catch (err) {
					_didIteratorError3 = true;
					_iteratorError3 = err;
				} finally {
					try {
						if (!_iteratorNormalCompletion3 && _iterator3.return) {
							_iterator3.return();
						}
					} finally {
						if (_didIteratorError3) {
							throw _iteratorError3;
						}
					}
				}
			}
		}

		return publicRenderParameters;
	};

	/**
  * Returns a URL of the specified type.
  * @param {Object} pageRenderState The page render state.
  * @param {string} type The URL type.
  * @param {string} portletId The portlet ID.
  * @param {Object} parameters Additional parameters. May be <code>null</code>.
  * @param {string} cache Cacheability. Must be present if type = "RESOURCE". May be <code>null</code>.
  * @param {string} resourceId Resource ID. May be present if type = "RESOURCE". May be <code>null</code>.
  * @return {Promise} A promise that resolves the generated URL.
  * @review
  */

	var getUrl = function getUrl(pageRenderState, type, portletId, parameters, cache, resourceId) {
		var cacheability = 'cacheLevelPage';
		var url = '';

		if (pageRenderState && pageRenderState.portlets) {

			// If target portlet not defined for render URL, set it to null

			if (type === 'RENDER' && portletId === undefined) {
				portletId = null;
			}

			var portletData = pageRenderState.portlets[portletId];

			if (portletData) {

				if (type === 'RESOURCE') {
					url = decodeURIComponent(portletData.encodedResourceURL);

					if (cache) {
						cacheability = cache;
					}

					url += TOKEN_DELIM + HUB + VALUE_DELIM + encodeURIComponent(HUB_RESOURCE);
					url += TOKEN_DELIM + CACHE_LEVEL + VALUE_DELIM + encodeURIComponent(cacheability);

					if (resourceId) {
						url += TOKEN_DELIM + RESOURCE_ID + VALUE_DELIM + encodeURIComponent(resourceId);
					}
				} else if (type === 'RENDER' && portletId !== null) {
					url = decodeURIComponent(portletData.encodedRenderURL);
				} else if (type === 'RENDER') {
					url = decodeURIComponent(pageRenderState.encodedCurrentURL);
				} else if (type === 'ACTION') {
					url = decodeURIComponent(portletData.encodedActionURL);
					url += TOKEN_DELIM + HUB + VALUE_DELIM + encodeURIComponent(HUB_ACTION);
				} else if (type === 'PARTIAL_ACTION') {
					url = decodeURIComponent(portletData.encodedActionURL);
					url += TOKEN_DELIM + HUB + VALUE_DELIM + encodeURIComponent(HUB_PARTIAL_ACTION);
				}

				// Now add the state to the URL, taking into account cacheability if
				// we're dealing with a resource URL.

				// Put the private & public parameters on the URL if cacheability != FULL

				if (type !== 'RESOURCE' || cacheability !== 'cacheLevelFull') {

					// Add the state for the target portlet, if there is one.
					// (for the render URL, pid can be null, and the state will have
					// been added previously)

					if (portletId) {
						if (portletData.state && portletData.state.parameters) {
							var stateParameters = portletData.state.parameters;

							var str = '';

							var keys = Object.keys(stateParameters);

							for (var key in keys) {
								if (!isPublicParameter(pageRenderState, portletId, key)) {
									str += generateParameterString(pageRenderState, portletId, key, RENDER_PARAM);
								}
							}
							url += str;
						}
					}

					// Add the public render parameters for all portlets

					if (pageRenderState.prpMap) {
						var publicRenderParameters = {};

						var _str = '';

						var mapKeys = Object.keys(pageRenderState.prpMap);
						var _iteratorNormalCompletion4 = true;
						var _didIteratorError4 = false;
						var _iteratorError4 = undefined;

						try {
							for (var _iterator4 = mapKeys[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
								var mapKey = _step4.value;

								var groupKeys = Object.keys(pageRenderState.prpMap[mapKey]);
								var _iteratorNormalCompletion5 = true;
								var _didIteratorError5 = false;
								var _iteratorError5 = undefined;

								try {
									for (var _iterator5 = groupKeys[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {
										var groupKey = _step5.value;

										var groupName = pageRenderState.prpMap[mapKey][groupKey];
										var parts = groupName.split('|');

										// Only need to add parameter once, since it is shared

										if (!publicRenderParameters.hasOwnProperty(mapKey)) {
											publicRenderParameters[mapKey] = generateParameterString(pageRenderState, parts[0], parts[1], PUBLIC_RENDER_PARAM, mapKey);

											_str += publicRenderParameters[mapKey];
										}
									}
								} catch (err) {
									_didIteratorError5 = true;
									_iteratorError5 = err;
								} finally {
									try {
										if (!_iteratorNormalCompletion5 && _iterator5.return) {
											_iterator5.return();
										}
									} finally {
										if (_didIteratorError5) {
											throw _iteratorError5;
										}
									}
								}
							}
						} catch (err) {
							_didIteratorError4 = true;
							_iteratorError4 = err;
						} finally {
							try {
								if (!_iteratorNormalCompletion4 && _iterator4.return) {
									_iterator4.return();
								}
							} finally {
								if (_didIteratorError4) {
									throw _iteratorError4;
								}
							}
						}

						url += _str;
					}
				}
			}
		}

		if (parameters) {
			var _str2 = '';

			var parameterKeys = Object.keys(parameters);
			var _iteratorNormalCompletion6 = true;
			var _didIteratorError6 = false;
			var _iteratorError6 = undefined;

			try {
				for (var _iterator6 = parameterKeys[Symbol.iterator](), _step6; !(_iteratorNormalCompletion6 = (_step6 = _iterator6.next()).done); _iteratorNormalCompletion6 = true) {
					var parameterKey = _step6.value;

					_str2 += encodeParameter(portletId + parameterKey, parameters[parameterKey]);
				}
			} catch (err) {
				_didIteratorError6 = true;
				_iteratorError6 = err;
			} finally {
				try {
					if (!_iteratorNormalCompletion6 && _iterator6.return) {
						_iterator6.return();
					}
				} finally {
					if (_didIteratorError6) {
						throw _iteratorError6;
					}
				}
			}

			url += _str2;
		}

		return Promise.resolve(url);
	};

	/**
  * Compares two parameters and returns a boolean indicating if they're equal
  * or not.
  * @param {?Array.<string>} parameter1 The first parameter to compare.
  * @param {?Array.<string>} parameter2 The second parameter to compare.
  * @return {boolean}
  * @review
  */

	var isParameterEqual = function isParameterEqual(parameter1, parameter2) {
		var result = false;

		// The values are either string arrays or undefined.

		if (parameter1 === undefined && parameter2 === undefined) {
			result = true;
		}

		if (parameter1 === undefined || parameter2 === undefined) {
			result = false;
		}

		if (parameter1.length !== parameter2.length) {
			result = false;
		}

		for (var i = parameter1.length - 1; i >= 0; i--) {
			if (parameter1[i] !== parameter2[i]) {
				result = false;
			}
		}

		return result;
	};

	/**
  * Compares the values of the named parameter in the new render state
  * with the values of that parameter in the current state.
  * @param {Object} pageRenderState The page render state.
  * @param {string} portletId The portlet ID.
  * @param {RenderState} state The new render state.
  * @param {string} name The name of the parameter to check.
  * @return {boolean} True if the new parameter's value is different from the current value.
  * @review
  */

	var isParameterInStateEqual = function isParameterInStateEqual(pageRenderState, portletId, state, name) {
		var result = false;

		if (pageRenderState && pageRenderState.portlets) {

			var portletData = pageRenderState.portlets[portletId];

			if (state.parameters[name] && portletData.state.parameters[name]) {
				var newParameter = state.parameters[name];
				var oldParameter = portletData.state.parameters[name];

				result = isParameterEqual(newParameter, oldParameter);
			}
		}

		return result;
	};

	/**
  * Function for checking if a parameter is public.
  * @param {Object} pageRenderState The page render state.
  * @param {string} portletId  The portlet ID.
  * @param {string} name  The name of the parameter to check.
  * @return {boolean}
  * @review
  */

	var isPublicParameter = function isPublicParameter(pageRenderState, portletId, name) {
		var result = false;

		if (pageRenderState && pageRenderState.portlets) {
			var portletData = pageRenderState.portlets[portletId];

			if (portletData && portletData.pubParams) {
				var keys = Object.keys(portletData.pubParams);
				result = keys.indexOf(name) !== -1;
			}
		}

		return result;
	};

	/**
  * Returns true if input state differs from the current page state.
  * Throws exception if input state is malformed.
  * @param {Object} pageRenderState The (current) page render state.
  * @param {RenderState} newState The new state to be set.
  * @param {string} portletId The portlet ID.
  * @return {boolean}  True if the two state are different.
  * @review
  */

	var stateChanged = function stateChanged(pageRenderState, newState, portletId) {
		var result = false;

		if (pageRenderState && pageRenderState.portlets) {
			var portletData = pageRenderState.portlets[portletId];

			if (portletData) {
				var oldState = pageRenderState.portlets[portletId].state;

				if (!newState.portletMode || !newState.windowState || !newState.parameters) {
					throw new Error('Error decoding state: ' + newState);
				}

				if (newState.porletMode !== oldState.portletMode || newState.windowState !== oldState.windowState) {
					result = true;
				} else {

					// Has a parameter changed or been added?

					var newKeys = Object.keys(newState.parameters);
					var _iteratorNormalCompletion7 = true;
					var _didIteratorError7 = false;
					var _iteratorError7 = undefined;

					try {
						for (var _iterator7 = newKeys[Symbol.iterator](), _step7; !(_iteratorNormalCompletion7 = (_step7 = _iterator7.next()).done); _iteratorNormalCompletion7 = true) {
							var key = _step7.value;

							var newParameter = newState.parameters[key];
							var oldParameter = oldState.parameters[key];

							if (!isParameterEqual(newParameter, oldParameter)) {
								result = true;
							}
						}

						// Make sure no parameter was deleted
					} catch (err) {
						_didIteratorError7 = true;
						_iteratorError7 = err;
					} finally {
						try {
							if (!_iteratorNormalCompletion7 && _iterator7.return) {
								_iterator7.return();
							}
						} finally {
							if (_didIteratorError7) {
								throw _iteratorError7;
							}
						}
					}

					var oldKeys = Object.keys(oldState.parameters);
					var _iteratorNormalCompletion8 = true;
					var _didIteratorError8 = false;
					var _iteratorError8 = undefined;

					try {
						for (var _iterator8 = oldKeys[Symbol.iterator](), _step8; !(_iteratorNormalCompletion8 = (_step8 = _iterator8.next()).done); _iteratorNormalCompletion8 = true) {
							var _key = _step8.value;

							if (!newState.parameters[_key]) {
								result = true;
							}
						}
					} catch (err) {
						_didIteratorError8 = true;
						_iteratorError8 = err;
					} finally {
						try {
							if (!_iteratorNormalCompletion8 && _iterator8.return) {
								_iterator8.return();
							}
						} finally {
							if (_didIteratorError8) {
								throw _iteratorError8;
							}
						}
					}
				}
			}
		}

		return result;
	};

	/**
  * Validates an HTMLFormElement
  * @param {?HTMLFormElement} form The form element to be validated.
  * @throws {TypeError} Thrown if the form is not an HTMLFormElement.
  * @throws {TypeError} Thrown if the form's method attribute is not valid.
  * @throws {TypeError} Thrown if the form's enctype attribute is not valid.
  * @throws {TypeError} Thrown if the form's enctype attribute is not valid.
  * @review
  */

	var validateForm = function validateForm(form) {
		if (!(form instanceof HTMLFormElement)) {
			throw new TypeError('Element must be an HTMLFormElement');
		}

		var method = form.method ? form.method.toUpperCase() : undefined;

		if (method && method !== 'GET' && method !== 'POST') {
			throw new TypeError('Invalid form method ' + method + '. Allowed methods are GET & POST');
		}

		var enctype = form.enctype;

		if (enctype && enctype !== 'application\/x-www-form-urlencoded' && enctype !== 'multipart\/form-data') {
			throw new TypeError('Invalid form enctype ' + enctype + '. Allowed: \'application/x-www-form-urlencoded\' & \'multipart/form-data\'');
		}

		if (enctype && enctype === 'multipart\/form-data' && method !== 'POST') {
			throw new TypeError('Invalid method with multipart/form-data. Must be POST');
		}

		if (!enctype || enctype === 'application\/x-www-form-urlencoded') {
			var l = form.elements.length;

			for (var i = 0; i < l; i++) {
				if (form.elements[i].nodeName.toUpperCase() === 'INPUT' && form.elements[i].type.toUpperCase() === 'FILE') {
					throw new TypeError('Must use enctype = \'multipart/form-data\' with input type FILE.');
				}
			}
		}
	};

	/**
  * Verifies that the input parameters are in valid format.
  *
  * Parameters must be an object containing parameter names. It may also
  * contain no property names which represents the case of having no
  * parameters.
  *
  * If properties are present, each property must refer to an array of string
  * values. The array length must be at least 1, because each parameter must
  * have a value. However, a value of 'null' may appear in any array entry.
  *
  * To represent a <code>null</code> value, the property value must equal [null].
  *
  * @param {Object} parameters The parameters to check.
  * @throws {TypeError} Thrown if the parameters are incorrect.
  * @review
  */

	var validateParameters = function validateParameters(parameters) {
		if (!(0, _metal.isDefAndNotNull)(parameters)) {
			throw new TypeError('The parameter object is: ' + (typeof parameters === 'undefined' ? 'undefined' : _typeof(parameters)));
		}

		var keys = Object.keys(parameters);
		var _iteratorNormalCompletion9 = true;
		var _didIteratorError9 = false;
		var _iteratorError9 = undefined;

		try {
			for (var _iterator9 = keys[Symbol.iterator](), _step9; !(_iteratorNormalCompletion9 = (_step9 = _iterator9.next()).done); _iteratorNormalCompletion9 = true) {
				var key = _step9.value;

				if (!Array.isArray(parameters[key])) {
					throw new TypeError(key + ' parameter is not an array');
				}

				if (!parameters[key].length) {
					throw new TypeError(key + ' parameter is an empty array');
				}
			}
		} catch (err) {
			_didIteratorError9 = true;
			_iteratorError9 = err;
		} finally {
			try {
				if (!_iteratorNormalCompletion9 && _iterator9.return) {
					_iterator9.return();
				}
			} finally {
				if (_didIteratorError9) {
					throw _iteratorError9;
				}
			}
		}
	};

	/**
  * Verifies that the input parameters are in valid format, that the portlet
  * mode and window state values are allowed for the portlet.
  * @param {RenderState} state The render state object to check.
  * @param {Object} portletData The porltet render state.
  * @throws {TypeError} Thrown if any component of the state is incorrect.
  * @review
  */

	var validateState = function validateState(state, portletData) {
		validateParameters(state.parameters);

		var portletMode = state.portletMode;

		if (!(0, _metal.isString)(portletMode)) {
			throw new TypeError('Invalid parameters. portletMode is ' + (typeof portletMode === 'undefined' ? 'undefined' : _typeof(portletMode)));
		} else {
			var allowedPortletModes = portletData.allowedPM;

			if (!allowedPortletModes.includes(portletMode.toLowerCase())) {
				throw new TypeError('Invalid portletMode=' + portletMode + ' is not in ' + allowedPortletModes);
			}
		}

		var windowState = state.windowState;

		if (!(0, _metal.isString)(windowState)) {
			throw new TypeError('Invalid parameters. windowState is ' + (typeof windowState === 'undefined' ? 'undefined' : _typeof(windowState)));
		} else {
			var allowedWindowStates = portletData.allowedWS;

			if (!allowedWindowStates.includes(windowState.toLowerCase())) {
				throw new TypeError('Invalid windowState=' + windowState + ' is not in ' + allowedWindowStates);
			}
		}
	};

	exports.decodeUpdateString = decodeUpdateString;
	exports.encodeFormAsString = encodeFormAsString;
	exports.generatePortletModeAndWindowStateString = generatePortletModeAndWindowStateString;
	exports.getUpdatedPublicRenderParameters = getUpdatedPublicRenderParameters;
	exports.getUrl = getUrl;
	exports.validateForm = validateForm;
	exports.validateParameters = validateParameters;
	exports.validateState = validateState;
});
//# sourceMappingURL=portlet_util.es.js.map