'use strict';

Liferay.Loader.define("frontend-js-web@2.0.6/liferay/modal/components/SimpleInputModal.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../../compat/modal/Modal.es', './SimpleInputModal.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.SimpleInputModal = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  var _metal = require("frontend-js-metal-web$metal");

  var _metalComponent = require("frontend-js-metal-web$metal-component");

  var _metalComponent2 = _interopRequireDefault(_metalComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _metalState = require("frontend-js-metal-web$metal-state");

  require('../../compat/modal/Modal.es');

  var _SimpleInputModal = require('./SimpleInputModal.soy');

  var _SimpleInputModal2 = _interopRequireDefault(_SimpleInputModal);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * SimpleInputModal
   * @review
   */

  var SimpleInputModal = function (_Component) {
    _inherits(SimpleInputModal, _Component);

    function SimpleInputModal() {
      _classCallCheck(this, SimpleInputModal);

      return _possibleConstructorReturn(this, (SimpleInputModal.__proto__ || Object.getPrototypeOf(SimpleInputModal)).apply(this, arguments));
    }

    _createClass(SimpleInputModal, [{
      key: 'attached',

      /**
       * @inheritDoc
       * @review
       */

      value: function attached() {
        this.addListener('formSubmit', this._defaultFormSubmit.bind(this), true);
      }

      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: 'rendered',
      value: function rendered() {
        var _this2 = this;

        requestAnimationFrame(function () {
          _this2.refs.modal.refs.mainField.focus();
        });
      }

      /**
       * Default event listener for form submission.
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: '_defaultFormSubmit',
      value: function _defaultFormSubmit(event) {
        var _this3 = this;

        fetch(this.formSubmitURL, {
          body: new FormData(event.form),
          credentials: 'include',
          method: 'POST'
        }).then(function (response) {
          return response.json();
        }).then(function (responseContent) {
          if (responseContent.error) {
            _this3._loadingResponse = false;
            _this3._handleFormError(responseContent);
          } else {
            _this3._handleFormSuccess(responseContent);
          }
        }).catch(function (response) {
          _this3._handleFormError(response);
        });

        this._loadingResponse = true;
      }

      /**
       * Callback executed when the SimpleInputModal cancel button
       * has been clicked.
       * @private
       * @review
       */

    }, {
      key: '_handleCancelButtonClick',
      value: function _handleCancelButtonClick() {
        this.emit('cancelButtonClicked');
      }

      /**
       * Callback executed when the SimpleInputModal form has been
       * submited and it receives a server error as response.
       * It emits a formError event with the errorMessage received.
       * @param {{error: string}} responseContent
       * @private
       * @review
       */

    }, {
      key: '_handleFormError',
      value: function _handleFormError(responseContent) {
        this._errorMessage = responseContent.error || '';

        this.emit('formError', {
          errorMessage: this._errorMessage
        });
      }

      /**
       * Callback executed when the SimpleInputModal form has been
       * submited. It prevents the default behaviour and sends this form
       * using a fetch request.
       * @param {Event} event
       * @private
       * @review
       */

    }, {
      key: '_handleFormSubmit',
      value: function _handleFormSubmit(event) {
        event.preventDefault();

        this.emit('formSubmit', {
          form: this.refs.modal.refs.form
        });
      }

      /**
       * Callback executed when the SimpleInputModal form has been
       * submited and it receives a server successful response.
       * It emits a formSuccess event with the redirectURL received.
       * @param {{redirectURL: string}} responseContent
       * @private
       * @review
       */

    }, {
      key: '_handleFormSuccess',
      value: function _handleFormSuccess(responseContent) {
        this.emit('formSuccess', {
          redirectURL: responseContent.redirectURL || ''
        });
      }

      /**
       * Callback executed when the modal visibility property changes
       * @private
       * @review
       */

    }, {
      key: '_handleModalVisibleChanged',
      value: function _handleModalVisibleChanged() {
        this.emit('dialogHidden');
      }
    }]);

    return SimpleInputModal;
  }(_metalComponent2.default);

  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  SimpleInputModal.STATE = {

    /**
     * Label for the optional checkbox
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */

    checkboxFieldLabel: _metalState.Config.setter(function (checkboxFieldLabel) {
      return (0, _metal.isString)(checkboxFieldLabel) && checkboxFieldLabel ? _metalSoy2.default.toIncDom(checkboxFieldLabel) : '';
    }).string().value(''),

    /**
     * Name for the optional checkbox
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */

    checkboxFieldName: _metalState.Config.string().value(''),

    /**
     * Initial value for the optional checkbox
     * @default false
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {boolean}
     */

    checkboxFieldValue: _metalState.Config.bool().value(false),

    /**
     * Modal window title
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */

    dialogTitle: _metalState.Config.string().required(),

    /**
     * URL where the form will be submitted to
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */

    formSubmitURL: _metalState.Config.string().required(),

    /**
     * Autogenerated id provided by templates
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */

    id: _metalState.Config.string().value(''),

    /**
     * Name for the hidden id field
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */

    idFieldName: _metalState.Config.string().value(''),

    /**
     * Value for the hidden id field
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */

    idFieldValue: _metalState.Config.string().value(''),

    /**
     * Label for the main field
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */

    mainFieldLabel: _metalState.Config.setter(function (mainFieldLabel) {
      return _metalSoy2.default.toIncDom(mainFieldLabel);
    }).string().required(),

    /**
     * Name for the main field
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */

    mainFieldName: _metalState.Config.string().required(),

    /**
     * Placeholder for the main field
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */

    mainFieldPlaceholder: _metalState.Config.string().value(''),

    /**
     * Initial value for the main field
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {string}
     */

    mainFieldValue: _metalState.Config.string().value(''),

    /**
     * Namespace that will be prepended to field names
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */

    namespace: _metalState.Config.string().required(),

    /**
     * URL for the portal icons being used
     * @default undefined
     * @instance
     * @memberOf SimpleInputModal
     * @review
     * @type {!string}
     */

    spritemap: _metalState.Config.string().required(),

    /**
     * Form error message returned by the server
     * @default ''
     * @instance
     * @memberOf SimpleInputModal
     * @private
     * @review
     * @type {!string}
     */

    _errorMessage: _metalState.Config.string().internal().value(''),

    /**
     * Flag indicating if we are waiting for a server response
     * after a form submission.
     * @default false
     * @instance
     * @memberOf SimpleInputModal
     * @private
     * @review
     * @type {boolean}
     */

    _loadingResponse: _metalState.Config.bool().internal().value(false)
  };

  _metalSoy2.default.register(SimpleInputModal, _SimpleInputModal2.default);

  exports.SimpleInputModal = SimpleInputModal;
  exports.default = SimpleInputModal;
});
//# sourceMappingURL=SimpleInputModal.es.js.map