'use strict';

Liferay.Loader.define("frontend-js-web@2.0.6/liferay/compat/slider/Slider.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-soy', './Slider.soy'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Slider = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _metal = require("frontend-js-metal-web$metal");

	var _metal2 = _interopRequireDefault(_metal);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalComponent = require("frontend-js-metal-web$metal-component");

	var _metalComponent2 = _interopRequireDefault(_metalComponent);

	var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

	var _metalPosition = require("frontend-js-metal-web$metal-position");

	var _metalPosition2 = _interopRequireDefault(_metalPosition);

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	var _Slider = require('./Slider.soy');

	var _Slider2 = _interopRequireDefault(_Slider);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Slider component.
  */

	var Slider = function (_Component) {
		_inherits(Slider, _Component);

		function Slider() {
			_classCallCheck(this, Slider);

			return _possibleConstructorReturn(this, (Slider.__proto__ || Object.getPrototypeOf(Slider)).apply(this, arguments));
		}

		_createClass(Slider, [{
			key: 'attached',

			/**
    * @inheritDoc
    */

			value: function attached() {
				this.drag_ = new _metalDragDrop.Drag({
					axis: 'x',
					constrain: this.constrainToRail_.bind(this),
					container: this.element,
					handles: '.handle',
					sources: '.rail-handle'
				});
				this.on('elementChanged', this.handleElementChanged_);

				this.attachDragEvents_();
			}

			/**
    * Attaches the drag events to handle value updates when dragging the rail handle.
    * protected
    */

		}, {
			key: 'attachDragEvents_',
			value: function attachDragEvents_() {
				this.drag_.on(_metalDragDrop.Drag.Events.DRAG, this.updateValueFromDragData_.bind(this));
				this.drag_.on(_metalDragDrop.Drag.Events.END, this.updateValueFromDragData_.bind(this));
			}

			/**
    * Constrains the given region to be inside the rail. This is being used
    * instead of `Drag`'s default behavior, because `Drag` would require the
    * whole handle to be inside the rail element, while we just want to make sure
    * that the left side of the handle is inside it.
    * @param {!Object} region
    * @protected
    */

		}, {
			key: 'constrainToRail_',
			value: function constrainToRail_(region) {
				var constrain = _metalPosition2.default.getRegion(this.refs.rail, true);
				if (region.left < constrain.left) {
					region.left = constrain.left;
				} else if (region.left > constrain.right) {
					region.left -= region.left - constrain.right;
				}
				region.right = region.left + region.width;
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'disposeInternal',
			value: function disposeInternal() {
				_get(Slider.prototype.__proto__ || Object.getPrototypeOf(Slider.prototype), 'disposeInternal', this).call(this);
				this.drag_.dispose();
			}

			/**
    * Returns the `Drag` instance being used.
    * @return {!Drag}
    */

		}, {
			key: 'getDrag',
			value: function getDrag() {
				return this.drag_;
			}

			/**
    * Handles the `elementChanged` event. Updates the drag container to the new
    * element, and also updates the constrain element.
    * @param {!Object} data
    * @protected
    */

		}, {
			key: 'handleElementChanged_',
			value: function handleElementChanged_(data) {
				if (data.newVal) {
					this.drag_.container = data.newVal;
				}
			}

			/**
    * Handles mouse down actions on the slider rail and updates the slider value accordingly.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: 'onRailClick_',
			value: function onRailClick_(event) {
				if (_metalDom2.default.hasClass(event.target, 'rail') || _metalDom2.default.hasClass(event.target, 'rail-active')) {
					var prevValue = this.value;
					this.updateValue_(event.offsetX, 0, true);
					if (prevValue === this.value) {
						var handleRegion = _metalPosition2.default.getRegion(this.refs.handle);
						if (event.offsetX < handleRegion.left) {
							this.value -= 1;
						} else {
							this.value += 1;
						}
					}
				}
			}

			/**
    * Synchronizes the slider UI with the `max` state key.
    * @param {number} newVal The new value of the state key.
    */

		}, {
			key: 'syncMax',
			value: function syncMax(newVal) {
				if (newVal < this.value) {
					this.value = newVal;
				}
			}

			/**
    * Synchronizes the slider UI with the `min` state key.
    * @param {number} newVal The new value of the state key.
    */

		}, {
			key: 'syncMin',
			value: function syncMin(newVal) {
				if (newVal > this.value) {
					this.value = newVal;
				}
			}

			/**
    * Updates the slider value based on the UI state of the handle element.
    * @param {number} handlePosition Position of the handle in px.
    * @param {number} offset Offset to be added to normalize relative inputs.
    * @param {boolean=} opt_relative If the given position is relative to the
    *     rail or not.
    * @protected
    */

		}, {
			key: 'updateValue_',
			value: function updateValue_(handlePosition, offset, opt_relative) {
				var region = _metalPosition2.default.getRegion(this.element);
				if (!opt_relative) {
					handlePosition -= region.left;
				}
				this.value = Math.round(offset + handlePosition / region.width * (this.max - this.min));
			}

			/**
    * Handles Drag events from the rail handle and updates the slider value accordingly.
    * @param {!Object} data
    * @protected
    */

		}, {
			key: 'updateValueFromDragData_',
			value: function updateValueFromDragData_(data, event) {
				this.updateValue_(data.x, this.min);
				event.preventDefault();
			}
		}]);

		return Slider;
	}(_metalComponent2.default);

	_metalSoy2.default.register(Slider, _Slider2.default);

	/**
  * `Slider`'s state definition.
  */

	Slider.STATE = {

		/**
   * Name of the hidden input field that holds the slider value. Useful when slider is embedded
   * inside a form so it can automatically send its value.
   * @type {string}
   */

		inputName: {
			validator: _metal2.default.isString
		},

		/**
   * Defines the maximum value handled by the slider.
   * @type {number}
   * @default 100
   */

		max: {
			value: 100
		},

		/**
   * Defines the minimum value handled by the slider.
   * @type {number}
   * @default 0
   */

		min: {
			value: 0
		},

		/**
   * Defines the currently selected value on the slider.
   * @type {number}
   * @default 0
   */

		value: {
			validator: function validator(val) {
				return _metal2.default.isNumber(val) && this.min <= val && val <= this.max;
			},
			value: 0
		}
	};

	exports.Slider = Slider;
	exports.default = Slider;
});
//# sourceMappingURL=Slider.es.js.map