'use strict';

Liferay.Loader.define('frontend-js-web@2.0.6/liferay/compat/progressbar/ProgressBar.soy', ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.templates = exports.liferayfrontendProgressBar = undefined;

  var _metalComponent = require('frontend-js-metal-web$metal-component');

  var _metalComponent2 = _interopRequireDefault(_metalComponent);

  var _metalSoy = require('frontend-js-metal-web$metal-soy');

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  } /* jshint ignore:start */

  var templates;
  goog.loadModule(function (exports) {
    var soy = goog.require('soy');
    var soydata = goog.require('soydata');
    // This file was automatically generated from ProgressBar.soy.
    // Please don't edit this file by hand.

    /**
     * @fileoverview Templates in namespace liferay.frontend.ProgressBar.
     * @public
     */

    goog.module('liferay.frontend.ProgressBar.incrementaldom');

    goog.require('goog.soy.data.SanitizedContent');
    var incrementalDom = goog.require('incrementaldom');
    goog.require('soy.asserts');
    var soyIdom = goog.require('soy.idom');

    /**
     * @param {{
     *  barClass: (!goog.soy.data.SanitizedContent|null|string|undefined),
     *  elementClasses: (!goog.soy.data.SanitizedContent|null|string|undefined),
     *  max: (null|number|undefined),
     *  min: (null|number|undefined),
     *  value: (null|number|undefined),
     *  label: (!goog.soy.data.SanitizedContent|function()|null|string|undefined)
     * }} opt_data
     * @param {Object<string, *>=} opt_ijData
     * @param {Object<string, *>=} opt_ijData_deprecated
     * @return {void}
     * @suppress {checkTypes}
     */
    function $render(opt_data, opt_ijData, opt_ijData_deprecated) {
      opt_ijData = opt_ijData_deprecated || opt_ijData;
      opt_data = opt_data || {};
      /** @type {!goog.soy.data.SanitizedContent|null|string|undefined} */
      var barClass = soy.asserts.assertType(opt_data.barClass == null || goog.isString(opt_data.barClass) || opt_data.barClass instanceof goog.soy.data.SanitizedContent, 'barClass', opt_data.barClass, '!goog.soy.data.SanitizedContent|null|string|undefined');
      /** @type {!goog.soy.data.SanitizedContent|null|string|undefined} */
      var elementClasses = soy.asserts.assertType(opt_data.elementClasses == null || goog.isString(opt_data.elementClasses) || opt_data.elementClasses instanceof goog.soy.data.SanitizedContent, 'elementClasses', opt_data.elementClasses, '!goog.soy.data.SanitizedContent|null|string|undefined');
      /** @type {null|number|undefined} */
      var max = soy.asserts.assertType(opt_data.max == null || goog.isNumber(opt_data.max), 'max', opt_data.max, 'null|number|undefined');
      /** @type {null|number|undefined} */
      var min = soy.asserts.assertType(opt_data.min == null || goog.isNumber(opt_data.min), 'min', opt_data.min, 'null|number|undefined');
      /** @type {null|number|undefined} */
      var value = soy.asserts.assertType(opt_data.value == null || goog.isNumber(opt_data.value), 'value', opt_data.value, 'null|number|undefined');
      /** @type {!goog.soy.data.SanitizedContent|function()|null|string|undefined} */
      var label = soy.asserts.assertType(opt_data.label == null || goog.isFunction(opt_data.label) || goog.isString(opt_data.label) || opt_data.label instanceof goog.soy.data.SanitizedContent, 'label', opt_data.label, '!goog.soy.data.SanitizedContent|function()|null|string|undefined');
      var curMax__soy559 = max ? max : 100;
      var curMin__soy561 = min ? min : 0;
      var curValue__soy563 = value ? value : 0;
      incrementalDom.elementOpenStart('div');
      incrementalDom.attr('class', 'progress ' + (elementClasses ? ' ' + elementClasses : ''));
      incrementalDom.attr('role', 'progressbar');
      incrementalDom.attr('aria-valuemax', curMax__soy559);
      incrementalDom.attr('aria-valuemin', curMin__soy561);
      incrementalDom.attr('aria-valuenow', curValue__soy563);
      incrementalDom.attr('tabindex', '0');
      incrementalDom.elementOpenEnd();
      var percentage__soy573 = Math.floor((curValue__soy563 - curMin__soy561) * 100 / (curMax__soy559 - curMin__soy561));
      incrementalDom.elementOpenStart('div');
      incrementalDom.attr('class', 'progress-bar' + (barClass ? ' ' + barClass : ''));
      incrementalDom.attr('style', 'width: ' + percentage__soy573 + '%');
      incrementalDom.elementOpenEnd();
      soyIdom.print(label ? label : '');
      incrementalDom.elementClose('div');
      incrementalDom.elementClose('div');
    }
    exports.render = $render;
    /**
     * @typedef {{
     *  barClass: (!goog.soy.data.SanitizedContent|null|string|undefined),
     *  elementClasses: (!goog.soy.data.SanitizedContent|null|string|undefined),
     *  max: (null|number|undefined),
     *  min: (null|number|undefined),
     *  value: (null|number|undefined),
     *  label: (!goog.soy.data.SanitizedContent|function()|null|string|undefined)
     * }}
     */
    $render.Params;
    if (goog.DEBUG) {
      $render.soyTemplateName = 'liferay.frontend.ProgressBar.render';
    }

    exports.render.params = ["barClass", "elementClasses", "max", "min", "value", "label"];
    exports.render.types = { "barClass": "string", "elementClasses": "string", "max": "int", "min": "int", "value": "int", "label": "html|string" };
    exports.templates = templates = exports;
    return exports;
  });

  var liferayfrontendProgressBar = function (_Component) {
    _inherits(liferayfrontendProgressBar, _Component);

    function liferayfrontendProgressBar() {
      _classCallCheck(this, liferayfrontendProgressBar);

      return _possibleConstructorReturn(this, (liferayfrontendProgressBar.__proto__ || Object.getPrototypeOf(liferayfrontendProgressBar)).apply(this, arguments));
    }

    return liferayfrontendProgressBar;
  }(_metalComponent2.default);

  _metalSoy2.default.register(liferayfrontendProgressBar, templates);
  exports.liferayfrontendProgressBar = liferayfrontendProgressBar;
  exports.templates = templates;
  exports.default = templates;
  /* jshint ignore:end */
});
//# sourceMappingURL=ProgressBar.soy.js.map