'use strict';

Liferay.Loader.define("frontend-js-web@2.0.6/liferay/compat/modal/Modal.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-events', './Modal.soy'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Modal = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _metalComponent = require("frontend-js-metal-web$metal-component");

	var _metalComponent2 = _interopRequireDefault(_metalComponent);

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	var _metal = require("frontend-js-metal-web$metal");

	var _metal2 = _interopRequireDefault(_metal);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalEvents = require("frontend-js-metal-web$metal-events");

	var _Modal = require('./Modal.soy');

	var _Modal2 = _interopRequireDefault(_Modal);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var KEY_CODE_ESC = 27;

	/**
  * Modal component.
  */

	var Modal = function (_Component) {
		_inherits(Modal, _Component);

		function Modal() {
			_classCallCheck(this, Modal);

			return _possibleConstructorReturn(this, (Modal.__proto__ || Object.getPrototypeOf(Modal)).apply(this, arguments));
		}

		_createClass(Modal, [{
			key: 'attached',

			/**
    * @inheritDoc
    */

			value: function attached() {
				this._autoFocus(this.autoFocus);

				this.addListener('hide', this._defaultHideFn, true);
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'created',
			value: function created() {
				this._eventHandler = new _metalEvents.EventHandler();
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'detached',
			value: function detached() {
				_get(Modal.prototype.__proto__ || Object.getPrototypeOf(Modal.prototype), 'detached', this).call(this);

				this._eventHandler.removeAllListeners();
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'disposeInternal',
			value: function disposeInternal() {
				_metalDom2.default.exitDocument(this.overlayElement);

				this._unrestrictFocus();

				_get(Modal.prototype.__proto__ || Object.getPrototypeOf(Modal.prototype), 'disposeInternal', this).call(this);
			}

			/**
    * Emits a hide event.
    */

		}, {
			key: 'hide',
			value: function hide() {
				this.emit('hide');
			}

			/**
    * Shows the modal, setting its `visible` state key to true.
    */

		}, {
			key: 'show',
			value: function show() {
				this.visible = true;
			}

			/**
    * Syncs the component according to the value of the `hideOnEscape` state key.
    * @param {boolean} hideOnEscape
    */

		}, {
			key: 'syncHideOnEscape',
			value: function syncHideOnEscape(hideOnEscape) {
				if (hideOnEscape) {
					this._eventHandler.add(_metalDom2.default.on(document, 'keyup', this._handleKeyup.bind(this)));
				} else {
					this._eventHandler.removeAllListeners();
				}
			}

			/**
    * Syncs the component according to the value of the `overlay` state key.
    * @param {boolean} overlay
    */

		}, {
			key: 'syncOverlay',
			value: function syncOverlay(overlay) {
				var willShowOverlay = overlay && this.visible;

				_metalDom2.default[willShowOverlay ? 'enterDocument' : 'exitDocument'](this.overlayElement);
			}

			/**
    * Syncs the component according to the value of the `visible` state key.
    */

		}, {
			key: 'syncVisible',
			value: function syncVisible() {
				this.syncOverlay(this.overlay);

				if (this.visible) {
					this._lastFocusedElement = this._lastFocusedElement || document.activeElement;

					this._autoFocus(this.autoFocus);
					this._restrictFocus();
				} else {
					this._unrestrictFocus();
					this._shiftFocusBack();
				}
			}

			/**
    * Automatically focuses the element specified by the given selector.
    * @param {boolean|string} autoFocusSelector The selector, or false if no
    *   element should be automatically focused.
    * @protected
    */

		}, {
			key: '_autoFocus',
			value: function _autoFocus(autoFocusSelector) {
				if (this.inDocument && this.visible && autoFocusSelector) {
					var element = this.element.querySelector(autoFocusSelector);

					if (element) {
						element.focus();
					}
				}
			}

			/**
    * Run only if no listener calls event.preventDefault().
    */

		}, {
			key: '_defaultHideFn',
			value: function _defaultHideFn() {
				this.visible = false;
			}

			/**
    * Handles a `focus` event on the document. If the focused element is
    * outside the modal and an overlay is being used, focuses the modal back.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: '_handleDocumentFocus',
			value: function _handleDocumentFocus(event) {
				if (this.overlay && !this.element.contains(event.target)) {
					this._autoFocus('.modal-dialog');
				}
			}

			/**
    * Handles document click in order to close the alert.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: '_handleKeyup',
			value: function _handleKeyup(event) {
				if (event.keyCode === KEY_CODE_ESC) {
					this.hide();
				}
			}

			/**
    * Restricts focus to the modal while it's visible.
    * @protected
    */

		}, {
			key: '_restrictFocus',
			value: function _restrictFocus() {
				if (!this._restrictFocusHandle) {
					this._restrictFocusHandle = _metalDom2.default.on(document, 'focus', this._handleDocumentFocus.bind(this), true);
				}
			}

			/**
    * Shifts the focus back to the last element that had been focused before the
    * modal was shown.
    * @protected
    */

		}, {
			key: '_shiftFocusBack',
			value: function _shiftFocusBack() {
				if (this._lastFocusedElement) {
					this._lastFocusedElement.focus();
					this._lastFocusedElement = null;
				}
			}

			/**
    * Removes the handler that restricts focus to elements inside the modal.
    * @protected
    */

		}, {
			key: '_unrestrictFocus',
			value: function _unrestrictFocus() {
				if (this._restrictFocusHandle) {
					this._restrictFocusHandle.removeListener();
					this._restrictFocusHandle = null;
				}
			}

			/**
    * Defines the default value for the `overlayElement` state key.
    * @protected
    * @return {Node}
    */

		}, {
			key: '_valueOverlayElementFn',
			value: function _valueOverlayElementFn() {
				return _metalDom2.default.buildFragment('<div class="modal-backdrop fade show"></div>').firstChild;
			}
		}]);

		return Modal;
	}(_metalComponent2.default);

	Modal.STATE = {

		/**
   * A selector for the element that should be automatically focused when the modal
   * becomes visible, or `false` if no auto focus should happen. Defaults to the
   * modal's close button.
   * @type {boolean|string}
   */

		autoFocus: {
			validator: function validator(val) {
				return val === false || _metal2.default.isString(val);
			},
			value: '.close'
		},

		/**
   * Content to be placed inside modal body. Can be either an html string or
   * a function that calls incremental-dom to render the body.
   * @type {string|function()}
   */

		body: {},

		/**
   * The id used by the body element.
   * @type {string}
   */

		bodyId: {
			valueFn: function valueFn() {
				return 'modal-body-' + _metal2.default.getUid();
			}
		},

		/**
   * Classes that will be applied to the modal-dialog element.
   * @type {string}
   */

		dialogClasses: {
			validator: _metal2.default.isString
		},

		/**
   * Content to be placed inside modal footer. Can be either an html string or
   * a function that calls incremental-dom to render the footer.
   * @type {string|function()}
   */

		footer: {},

		/**
   * The id used by the header element.
   * @type {string}
   */

		headerId: {
			valueFn: function valueFn() {
				return 'modal-header-' + _metal2.default.getUid();
			}
		},

		/**
   * Content to be placed inside modal header. Can be either an html string or
   * a function that calls incremental-dom to render the header.
   * @type {string|function()}
   */

		header: {},

		/**
   * Whether modal should hide on esc.
   * @type {boolean}
   * @default true
   */

		hideOnEscape: {
			validator: _metal2.default.isBoolean,
			value: true
		},

		/**
   * Flag indicating if the default "x" button for closing the modal should be
   * added or not.
   * @type {boolean}
   * @default false
   */

		noCloseButton: {
			value: false
		},

		/**
   * Whether overlay should be visible when modal is visible.
   * @type {boolean}
   * @default true
   */

		overlay: {
			validator: _metal2.default.isBoolean,
			value: true
		},

		/**
   * Element to be used as overlay.
   * @type {Element}
   */

		overlayElement: {
			valueFn: '_valueOverlayElementFn',
			writeOnce: true
		},

		/**
   * The ARIA role to be used for this modal.
   * @type {string}
   * @default 'dialog'
   */

		role: {
			validator: _metal2.default.isString,
			value: 'dialog'
		}
	};

	_metalSoy2.default.register(Modal, _Modal2.default);

	exports.Modal = Modal;
	exports.default = Modal;
});
//# sourceMappingURL=Modal.es.js.map