'use strict';

Liferay.Loader.define("frontend-js-web@2.0.6/liferay/compat/list/List.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './ListItem.es', './List.soy'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.List = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metal = require("frontend-js-metal-web$metal");

	var _metal2 = _interopRequireDefault(_metal);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalComponent = require("frontend-js-metal-web$metal-component");

	var _metalComponent2 = _interopRequireDefault(_metalComponent);

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	require('./ListItem.es');

	var _List = require('./List.soy');

	var _List2 = _interopRequireDefault(_List);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * List component.
  */

	var List = function (_Component) {
		_inherits(List, _Component);

		function List() {
			_classCallCheck(this, List);

			return _possibleConstructorReturn(this, (List.__proto__ || Object.getPrototypeOf(List)).apply(this, arguments));
		}

		_createClass(List, [{
			key: 'handleClick',

			/**
    * Handles click event on the list. The function fires an
    * {@code itemSelected} event.
    * @param {!Event} event The native click event
    */

			value: function handleClick(event) {
				var target = event.target;
				while (target) {
					if (_metalDom2.default.match(target, '.listitem')) {
						break;
					}
					target = target.parentNode;
				}
				this.emit('itemSelected', target);
			}
		}]);

		return List;
	}(_metalComponent2.default);

	_metalSoy2.default.register(List, _List2.default);

	/**
  * List state definition.
  * @type {!Object}
  * @static
  */

	List.STATE = {

		/**
   * A unique identifier for the component. It's also used to compound the
   * items' ID attribute unless if itemsHtml attribute is used.
   * @type {string}
   */

		id: {
			valueFn: function valueFn() {
				return 'list-component-' + _metal2.default.getUid();
			}
		},

		/**
   * The list items. Each is represented by an object that can have the following keys:
   *   - textPrimary: The item's main content.
   *   - textSecondary: (Optional) The item's help content.
   *   - icons: (Optional) A list of icon css classes to render on the right side.
   *   - iconsHtml: (Optional) A list of icon css classes to render on the right side.
   *   - avatar: (Optional) An object that specifies the avatar's content and, optionally, a css
   *       class it should use.
   * @type {!Array<!Object>}
   * @default []
   */

		items: {
			validator: Array.isArray,
			valueFn: function valueFn() {
				return [];
			}
		},

		/**
   * The list items as HTML to be added directly to the list.
   * @type {string}
   */

		itemsHtml: {
			isHtml: true
		}
	};

	exports.List = List;
	exports.default = List;
});
//# sourceMappingURL=List.es.js.map