'use strict';

Liferay.Loader.define("frontend-js-web@2.0.6/liferay/CompatibilityEventProxy.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metalState2 = _interopRequireDefault(_metalState);

	var _metal = require("frontend-js-metal-web$metal");

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * CompatibilityEventProxy
  *
  * This class adds compatibility for YUI events, re-emitting events
  * according to YUI naming and adding the capability of adding targets
  * to bubble events to them.
  * @review
  */

	var CompatibilityEventProxy = function (_State) {
		_inherits(CompatibilityEventProxy, _State);

		/**
   * @inheritDoc
   * @review
   */

		function CompatibilityEventProxy(config, element) {
			_classCallCheck(this, CompatibilityEventProxy);

			var _this = _possibleConstructorReturn(this, (CompatibilityEventProxy.__proto__ || Object.getPrototypeOf(CompatibilityEventProxy)).call(this, config, element));

			_this.eventTargets_ = [];
			_this.host = config.host;
			_this.namespace = config.namespace;

			_this.startCompatibility_();
			return _this;
		}

		/**
   * Registers another EventTarget as a bubble target.
   * @param  {!Object} target YUI component where events will be emited to
   * @private
   * @review
   */

		_createClass(CompatibilityEventProxy, [{
			key: 'addTarget',
			value: function addTarget(target) {
				this.eventTargets_.push(target);
			}

			/**
    * Check if the event is an attribute modification event and addapt
    * the eventName.
    * @param  {!String} eventName
    * @private
    * @return {String} Adapted event name
    * @review
    */

		}, {
			key: 'checkAttributeEvent_',
			value: function checkAttributeEvent_(eventName) {
				return eventName.replace(this.adaptedEvents.match, this.adaptedEvents.replace);
			}

			/**
    * Emit the event adapted to yui
    * @param  {!String} eventName
    * @param  {!Event} event
    * @private
    * @review
    */

		}, {
			key: 'emitCompatibleEvents_',
			value: function emitCompatibleEvents_(eventName, event) {
				var _this2 = this;

				this.eventTargets_.forEach(function (target) {
					if (target.fire) {
						var prefixedEventName = _this2.namespace ? _this2.namespace + ':' + eventName : eventName;
						var yuiEvent = target._yuievt.events[prefixedEventName];

						if (_metal.core.isObject(event)) {
							try {
								event.target = _this2.host;
							} catch (e) {}
						}

						var emitFacadeReference = void 0;

						if (!_this2.emitFacade && yuiEvent) {
							emitFacadeReference = yuiEvent.emitFacade;
							yuiEvent.emitFacade = false;
						}

						target.fire(prefixedEventName, event);

						if (!_this2.emitFacade && yuiEvent) {
							yuiEvent.emitFacade = emitFacadeReference;
						}
					}
				});
			}

			/**
    * Configuration to emit yui-based events to maintain
    * backwards compatibility.
    * @private
    * @review
    */

		}, {
			key: 'startCompatibility_',
			value: function startCompatibility_() {
				var _this3 = this;

				this.host.on('*', function (event, eventFacade) {
					if (!eventFacade) {
						eventFacade = event;
					}

					var compatibleEvent = _this3.checkAttributeEvent_(eventFacade.type);

					if (compatibleEvent !== eventFacade.type) {
						eventFacade.type = compatibleEvent;
						_this3.host.emit(compatibleEvent, event, eventFacade);
					} else if (_this3.eventTargets_.length > 0) {
						_this3.emitCompatibleEvents_(compatibleEvent, event);
					}
				});
			}
		}]);

		return CompatibilityEventProxy;
	}(_metalState2.default);

	/**
  * State definition.
  * @ignore
  * @review
  * @static
  * @type {!Object}
  */

	CompatibilityEventProxy.STATE = {

		/**
   * Regex for replace event names to YUI adapted names.
   * @review
   * @type {Object}
   */

		adaptedEvents: {
			value: {
				match: /(.*)(Changed)$/,
				replace: '$1Change'
			}
		},

		/**
   * Indicates if event facade should be emited to the target
   * @review
   * @type {String}
   */

		emitFacade: {
			value: false
		}
	};

	exports.default = CompatibilityEventProxy;
});
//# sourceMappingURL=CompatibilityEventProxy.es.js.map