/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.top.head.extender.internal.servlet.taglib;

import com.liferay.frontend.js.top.head.extender.TopHeadResources;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.servlet.PortalWebResources;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilderFactory;
import com.liferay.portal.util.JavaScriptBundleUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={DynamicInclude.class})
public class TopHeadDynamicInclude
implements DynamicInclude {
    @Reference
    private AbsolutePortalURLBuilderFactory _absolutePortalURLBuilderFactory;
    private volatile List<String> _allJsResourceURLs = new ArrayList<String>();
    private BundleContext _bundleContext;
    private String _comboContextPath;
    private String _jsContextPath = "";
    private volatile List<String> _jsResourceURLs = new ArrayList<String>();
    private Portal _portal;
    private PortalWebResources _portalWebResources;
    private final Collection<ServiceReference<TopHeadResources>> _topHeadResourcesServiceReferences = new TreeSet<ServiceReference<TopHeadResources>>();

    public void include(HttpServletRequest request, HttpServletResponse response, String key) throws IOException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay.isThemeJsFastLoad()) {
            if (themeDisplay.isThemeJsBarebone()) {
                this._renderBundleComboURLs(request, response, this._jsResourceURLs);
            } else {
                this._renderBundleComboURLs(request, response, this._allJsResourceURLs);
            }
        } else if (themeDisplay.isThemeJsBarebone()) {
            this._renderBundleURLs(request, response, this._jsResourceURLs);
        } else {
            this._renderBundleURLs(request, response, this._allJsResourceURLs);
        }
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("/html/common/themes/top_js.jspf#resources");
    }

    @Reference(unbind="-")
    public void setPortal(Portal portal) {
        String pathContext = portal.getPathContext();
        this._comboContextPath = pathContext.concat("/combo");
        this._portal = portal;
        this._rebuild();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addPortalWebResources(PortalWebResources portalWebResources) {
        String resourceType = portalWebResources.getResourceType();
        if (resourceType.equals("js")) {
            this._portalWebResources = portalWebResources;
            this._rebuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addTopHeadResources(ServiceReference<TopHeadResources> topHeadResourcesServiceReference) {
        Collection<ServiceReference<TopHeadResources>> collection = this._topHeadResourcesServiceReferences;
        synchronized (collection) {
            this._topHeadResourcesServiceReferences.add(topHeadResourcesServiceReference);
        }
        this._rebuild();
    }

    protected void removePortalWebResources(PortalWebResources portalWebResources) {
        String resourceType = portalWebResources.getResourceType();
        if (resourceType.equals("js")) {
            this._portalWebResources = null;
            this._rebuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTopHeadResources(ServiceReference<TopHeadResources> topHeadResourcesServiceReference) {
        Collection<ServiceReference<TopHeadResources>> collection = this._topHeadResourcesServiceReferences;
        synchronized (collection) {
            this._topHeadResourcesServiceReferences.remove(topHeadResourcesServiceReference);
        }
        this._rebuild();
    }

    private void _addPortalBundles(List<String> urls, String propsKey) {
        String[] fileNames;
        for (String fileName : fileNames = JavaScriptBundleUtil.getFileNames((String)propsKey)) {
            urls.add(this._jsContextPath + "/" + fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _rebuild() {
        if (this._portal == null || this._portalWebResources == null) {
            return;
        }
        this._jsContextPath = this._portal.getPathProxy();
        this._jsContextPath = this._jsContextPath.concat(this._portalWebResources.getContextPath());
        this._allJsResourceURLs.clear();
        this._addPortalBundles(this._allJsResourceURLs, "javascript.everything.files");
        this._jsResourceURLs.clear();
        this._addPortalBundles(this._jsResourceURLs, "javascript.barebone.files");
        Collection<ServiceReference<TopHeadResources>> collection = this._topHeadResourcesServiceReferences;
        synchronized (collection) {
            for (ServiceReference<TopHeadResources> topHeadResourcesServiceReference : this._topHeadResourcesServiceReferences) {
                TopHeadResources topHeadResources = (TopHeadResources)this._bundleContext.getService(topHeadResourcesServiceReference);
                try {
                    String proxyPath = this._portal.getPathProxy();
                    String servletContextPath = proxyPath.concat(topHeadResources.getServletContextPath());
                    for (String jsResourcePath : topHeadResources.getJsResourcePaths()) {
                        String url = servletContextPath.concat(jsResourcePath);
                        this._allJsResourceURLs.add(url);
                        this._jsResourceURLs.add(url);
                    }
                    for (String jsResourcePath : topHeadResources.getAuthenticatedJsResourcePaths()) {
                        this._allJsResourceURLs.add(servletContextPath.concat(jsResourcePath));
                    }
                }
                finally {
                    this._bundleContext.ungetService(topHeadResourcesServiceReference);
                }
            }
        }
    }

    private void _renderBundleComboURLs(HttpServletRequest request, HttpServletResponse response, List<String> urls) throws IOException {
        PrintWriter printWriter = response.getWriter();
        StringBundler sb = new StringBundler();
        long jsLastModified = -1L;
        if (this._portalWebResources != null) {
            jsLastModified = this._portalWebResources.getLastModified();
        }
        String comboURL = this._portal.getStaticResourceURL(request, this._comboContextPath, "minifierType=js", jsLastModified);
        for (String url : urls) {
            if (sb.length() == 0) {
                sb.append("<script data-senna-track=\"permanent\" src=\"");
                ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                sb.append(themeDisplay.getCDNBaseURL() + comboURL);
            }
            sb.append("&");
            sb.append(url);
            if (sb.length() < 2048) continue;
            sb.append("\" type = \"text/javascript\"></script>");
            printWriter.println(sb.toString());
            sb = new StringBundler();
        }
        if (sb.length() > 0) {
            sb.append("\" type = \"text/javascript\"></script>");
            printWriter.println(sb.toString());
        }
    }

    private void _renderBundleURLs(HttpServletRequest request, HttpServletResponse response, List<String> urls) throws IOException {
        PrintWriter printWriter = response.getWriter();
        for (String url : urls) {
            printWriter.print("<script data-senna-track=\"permanent\" src=\"");
            AbsolutePortalURLBuilder absolutePortalURLBuilder = this._absolutePortalURLBuilderFactory.getAbsolutePortalURLBuilder(request);
            printWriter.print(absolutePortalURLBuilder.forResource(url).build());
            printWriter.println("\" type=\"text/javascript\"></script>");
        }
    }
}

