/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.top.head.extender.internal;

import com.liferay.frontend.js.top.head.extender.internal.TopHeadExtension;
import com.liferay.frontend.js.top.head.extender.internal.TopHeadResourcesImpl;
import com.liferay.osgi.felix.util.AbstractExtender;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.utils.extender.Extension;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={})
public class TopHeadExtender
extends AbstractExtender {
    private Logger _logger;

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        this._logger = new Logger(bundleContext);
        this.start(bundleContext);
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) throws Exception {
        this.stop(bundleContext);
    }

    protected void debug(Bundle bundle, String s) {
        this._logger.log(4, StringBundler.concat((Object[])new Object[]{"[", bundle, "] ", s}));
    }

    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        Dictionary headers = bundle.getHeaders("");
        String liferayJsResourcesTopHead = (String)headers.get("Liferay-JS-Resources-Top-Head");
        String liferayJsResourcesTopHeadAuthenticated = (String)headers.get("Liferay-JS-Resources-Top-Head-Authenticated");
        if (Validator.isBlank((String)liferayJsResourcesTopHead) && Validator.isBlank((String)liferayJsResourcesTopHeadAuthenticated)) {
            return null;
        }
        List<Object> jsResourcePaths = null;
        jsResourcePaths = Validator.isNull((String)liferayJsResourcesTopHead) ? Collections.emptyList() : Arrays.asList(liferayJsResourcesTopHead.split(","));
        List<Object> authenticatedJsResourcePaths = null;
        authenticatedJsResourcePaths = Validator.isNull((String)liferayJsResourcesTopHeadAuthenticated) ? Collections.emptyList() : Arrays.asList(liferayJsResourcesTopHeadAuthenticated.split(","));
        TopHeadResourcesImpl topHeadResourcesImpl = new TopHeadResourcesImpl(jsResourcePaths, authenticatedJsResourcePaths);
        int liferayTopHeadWeight = GetterUtil.getInteger((String)((String)headers.get("Liferay-Top-Head-Weight")));
        return new TopHeadExtension(bundle, topHeadResourcesImpl, liferayTopHeadWeight);
    }

    protected void error(String s, Throwable t) {
        this._logger.log(1, s, t);
    }

    protected void warn(Bundle bundle, String s, Throwable t) {
        this._logger.log(2, StringBundler.concat((Object[])new Object[]{"[", bundle, "] ", s}), t);
    }
}

