/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.top.head.extender.internal;

import com.liferay.frontend.js.top.head.extender.internal.TopHeadExtension;
import com.liferay.frontend.js.top.head.extender.internal.TopHeadResourcesImpl;
import com.liferay.osgi.felix.util.AbstractExtender;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.Dictionary;
import org.apache.felix.utils.extender.Extension;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true)
public class TopHeadExtender
extends AbstractExtender {
    private Logger _logger;

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        this._logger = new Logger(bundleContext);
        this.start(bundleContext);
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) throws Exception {
        this.stop(bundleContext);
    }

    protected void debug(Bundle bundle, String s) {
        this._logger.log(4, StringBundler.concat((String[])new String[]{"[", String.valueOf(bundle), "] ", s}));
    }

    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        Dictionary headers = bundle.getHeaders("");
        String liferayJsResourcesTopHead = (String)headers.get("Liferay-JS-Resources-Top-Head");
        String liferayJsResourcesTopHeadAuthenticated = (String)headers.get("Liferay-JS-Resources-Top-Head-Authenticated");
        if (Validator.isBlank((String)liferayJsResourcesTopHead) && Validator.isBlank((String)liferayJsResourcesTopHeadAuthenticated)) {
            return null;
        }
        if (Validator.isNull((String)liferayJsResourcesTopHead)) {
            liferayJsResourcesTopHead = "";
        }
        if (Validator.isNull((String)liferayJsResourcesTopHeadAuthenticated)) {
            liferayJsResourcesTopHeadAuthenticated = "";
        }
        TopHeadResourcesImpl topHeadResourcesImpl = new TopHeadResourcesImpl(Arrays.asList(liferayJsResourcesTopHead.split(",")), Arrays.asList(liferayJsResourcesTopHeadAuthenticated.split(",")));
        int liferayTopHeadWeight = GetterUtil.getInteger((String)((String)headers.get("Liferay-Top-Head-Weight")));
        return new TopHeadExtension(bundle, topHeadResourcesImpl, liferayTopHeadWeight);
    }

    protected void error(String s, Throwable t) {
        this._logger.log(1, s, t);
    }

    protected void warn(Bundle bundle, String s, Throwable t) {
        this._logger.log(2, StringBundler.concat((String[])new String[]{"[", String.valueOf(bundle), "] ", s}), t);
    }
}

