Liferay.Loader.define('frontend-js-tooltip-support-web$lodash-es@4.17.15/reduceRight', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import arrayReduceRight from './_arrayReduceRight.js';
    import baseEachRight from './_baseEachRight.js';
    import baseIteratee from './_baseIteratee.js';
    import baseReduce from './_baseReduce.js';
    import isArray from './isArray.js';

    /**
     * This method is like `_.reduce` except that it iterates over elements of
     * `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [accumulator] The initial value.
     * @returns {*} Returns the accumulated value.
     * @see _.reduce
     * @example
     *
     * var array = [[0, 1], [2, 3], [4, 5]];
     *
     * _.reduceRight(array, function(flattened, other) {
     *   return flattened.concat(other);
     * }, []);
     * // => [4, 5, 2, 3, 0, 1]
     */
    function reduceRight(collection, iteratee, accumulator) {
      var func = isArray(collection) ? arrayReduceRight : baseReduce,
          initAccum = arguments.length < 3;

      return func(collection, baseIteratee(iteratee, 4), accumulator, initAccum, baseEachRight);
    }

    export default reduceRight;
  }
});
//# sourceMappingURL=reduceRight.js.map