Liferay.Loader.define('frontend-js-tooltip-support-web$lodash-es@4.17.15/camelCase', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import capitalize from './capitalize.js';
    import createCompounder from './_createCompounder.js';

    /**
     * Converts `string` to [camel case](https://en.wikipedia.org/wiki/CamelCase).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the camel cased string.
     * @example
     *
     * _.camelCase('Foo Bar');
     * // => 'fooBar'
     *
     * _.camelCase('--foo-bar--');
     * // => 'fooBar'
     *
     * _.camelCase('__FOO_BAR__');
     * // => 'fooBar'
     */
    var camelCase = createCompounder(function (result, word, index) {
      word = word.toLowerCase();
      return result + (index ? capitalize(word) : word);
    });

    export default camelCase;
  }
});
//# sourceMappingURL=camelCase.js.map